/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.server.session;

import com.funambol.framework.server.session.SessionExpiredException;
import com.funambol.framework.server.session.SessionHandler;
import java.io.Serializable;
import java.util.Collection;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractSessionManager
implements Serializable {
    private int lifeTime = 5;
    private static final Logger log = Logger.getLogger((String)AbstractSessionManager.class.getName());

    public int getLifeTime() {
        return this.lifeTime;
    }

    public void setLifeTime(int lifeTime) {
        this.lifeTime = lifeTime;
    }

    public SessionHandler getSessionHandler(String sessionId) throws SessionExpiredException {
        SessionHandler handler;
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("Looking for session " + sessionId));
        }
        if ((handler = this.getSessionFromBag(sessionId)) == null) {
            handler = this.createNewSession(sessionId);
            this.putSessionInBag(sessionId, handler);
        } else if (handler.isNew()) {
            handler.setNew(false);
            this.putSessionInBag(sessionId, handler);
        }
        return handler;
    }

    public void removeSession(String sessionId) {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("Removing session " + sessionId));
        }
        try {
            SessionHandler oldSession = this.getSessionFromBag(sessionId);
            oldSession.expire();
            this.removeSessionFromBag(sessionId);
        }
        catch (SessionExpiredException e) {
            log.trace((Object)"Session already expired");
        }
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("Remaining sessions: " + this.getSessionBag()));
        }
    }

    public void removeSession(SessionHandler handler) {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("Removing session " + (handler != null ? handler.getSessionId() : "null")));
        }
        handler.expire();
        this.removeSessionFromBag(handler.getSessionId());
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("Remaining sessions: " + this.getSessionBag()));
        }
    }

    public void storeSessionHandler(SessionHandler handler) {
        if (log.isEnabledFor((Priority)Level.TRACE)) {
            log.trace((Object)("Storing session " + handler));
        }
        this.putSessionInBag(handler.getSessionId(), handler);
    }

    protected abstract SessionHandler createNewSession(String var1);

    protected abstract SessionHandler getSessionFromBag(String var1) throws SessionExpiredException;

    protected abstract void putSessionInBag(String var1, SessionHandler var2);

    protected abstract void removeSessionFromBag(String var1);

    protected abstract Collection getSessionBag();
}

