/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.vmguys.vmtools.utils.AbstractOperation;
import org.vmguys.vmtools.utils.DiffElement;

public class AttributeDeleteOperation
extends AbstractOperation {
    private Attribute oldAttr;

    public AttributeDeleteOperation(DiffElement node, Attribute attr) {
        this(node, attr, null);
    }

    public AttributeDeleteOperation(DiffElement node, Attribute attr, String comment) {
        this.node = node;
        this.oldAttr = attr;
        this.comment = comment;
    }

    public Element asElement(Namespace namespace) {
        Element el = new Element("Attribute", namespace);
        el.setAttribute("Name", this.oldAttr.getQualifiedName());
        el.setAttribute("Operation", "delete");
        if (this.comment != null) {
            Comment c = new Comment(this.comment);
            el.addContent(c);
        }
        return el;
    }

    public int cost() {
        return 1;
    }

    public String toString() {
        String cmt = this.comment == null ? "" : " (" + this.comment + ")";
        return "delete attribute " + this.oldAttr.getQualifiedName() + " from node " + (Object)((Object)this.node);
    }

    public String getOperationXpath() throws JDOMException {
        return this.node.getXpath();
    }

    public int getOperationNodeNumber() {
        return this.node.getNodeNumber();
    }
}

