/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.core;

import com.funambol.framework.core.ComplexData;
import com.funambol.framework.core.Item;
import com.funambol.framework.core.Meta;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.tools.Base64;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;

public final class Util {
    private Util() {
    }

    public static String serializeWrapLong(Long l) {
        return String.valueOf(l);
    }

    public static Long deserializeWrapLong(String string) {
        if (string != null) {
            return Long.valueOf(string.trim());
        }
        return null;
    }

    public static Boolean deserializeBoolean(String string) {
        if (string != null && (string.equals("") || string.equalsIgnoreCase("true"))) {
            return Boolean.TRUE;
        }
        return null;
    }

    public static String serializeBoolean(Boolean bl) {
        return bl != false ? "" : null;
    }

    public static String toXML(SyncML syncML) {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IBindingFactory iBindingFactory = BindingDirectory.getFactory(SyncML.class);
            IMarshallingContext iMarshallingContext = iBindingFactory.createMarshallingContext();
            iMarshallingContext.setIndent(0);
            iMarshallingContext.marshalDocument((Object)syncML, "UTF-8", null, (OutputStream)byteArrayOutputStream);
            string = new String(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public static String toXML(Object object) {
        return Util.toXML(object, false);
    }

    public static String toXML(Object object, boolean bl) {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IBindingFactory iBindingFactory = BindingDirectory.getFactory(object.getClass());
            IMarshallingContext iMarshallingContext = iBindingFactory.createMarshallingContext();
            iMarshallingContext.setIndent(bl ? 1 : 0);
            iMarshallingContext.marshalDocument(object, "UTF-8", null, (OutputStream)byteArrayOutputStream);
            string = new String(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public static String toXML(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        int n = objectArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("Object: " + i + "\n");
            stringBuffer.append(Util.toXML(objectArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String toXML(List list) {
        if (list == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringBuffer.append("Object: " + n++ + "\n");
            stringBuffer.append(Util.toXML(iterator.next()));
        }
        return stringBuffer.toString();
    }

    public static boolean isItemWithBinaryData(Item item) {
        Meta meta = item.getMeta();
        if (meta == null) {
            return false;
        }
        String string = meta.getFormat();
        return string != null && string.equalsIgnoreCase("b64");
    }

    public static Long getItemSize(Item item) {
        Meta meta = item.getMeta();
        if (meta == null) {
            return null;
        }
        Long l = meta.getSize();
        return l;
    }

    public static Long getRealItemSize(Item item, String string) {
        Long l = null;
        ComplexData complexData = item.getData();
        if (complexData == null) {
            return null;
        }
        String string2 = complexData.getData();
        if (string2 == null) {
            return null;
        }
        boolean bl = Util.isItemWithBinaryData(item);
        if ("application/vnd.syncml.dm+xml".equals(string) || "application/vnd.syncml+xml".equals(string)) {
            bl = false;
        }
        if (bl) {
            byte[] byArray = Base64.decode(string2.getBytes());
            l = byArray.length;
        } else {
            l = string2.length();
        }
        return l;
    }
}

