/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.engine.dm;

import com.funambol.framework.core.AlertCode;
import com.funambol.framework.engine.dm.TreeManagementOperation;

public class UserAlertManagementOperation
extends TreeManagementOperation {
    protected final String INPUT_TYPES = "ANDTPI";
    protected final String ECHO_TYPES = "TP";
    private static final String DESCRIPTION = "Alert";
    protected String[] alerts;
    protected int minDisplayTime;
    protected int maxDisplayTime;
    protected String defaultResponse;
    protected int maxLength;
    protected char inputType;
    protected char echoType;
    protected int alertCode;

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    public UserAlertManagementOperation() {
    }

    public UserAlertManagementOperation(int alertCode, String[] alerts) throws IllegalArgumentException {
        this(alertCode, alerts, -1, -1, null, -1, ' ', ' ');
    }

    public UserAlertManagementOperation(int alertCode, String[] alerts, int mindt, int maxdt, String dr, int maxlen, char it, char et) {
        if (!AlertCode.isUserAlertCode(alertCode)) {
            throw new IllegalArgumentException(alertCode + " is not a user alert code");
        }
        if (it != ' ' && "ANDTPI".indexOf(it) < 0) {
            throw new IllegalArgumentException("Input type '" + it + "' is not one of " + "ANDTPI");
        }
        if (et != ' ' && "TP".indexOf(et) < 0) {
            throw new IllegalArgumentException("Echo type '" + et + "' is not one of " + "TP");
        }
        this.alertCode = alertCode;
        this.alerts = alerts == null ? new String[0] : alerts;
        this.minDisplayTime = mindt;
        this.maxDisplayTime = maxdt;
        this.defaultResponse = dr;
        this.maxLength = maxlen;
        this.inputType = it;
        this.echoType = et;
    }

    public int getMinDisplayTime() {
        return this.minDisplayTime;
    }

    public void setMinDisplayTime(int minDisplayTime) {
        this.minDisplayTime = minDisplayTime;
    }

    public String[] getAlerts() {
        return this.alerts;
    }

    public void setAlerts(String[] alerts) {
        this.alerts = alerts;
    }

    public int getMaxDisplayTime() {
        return this.maxDisplayTime;
    }

    public void setMaxDisplayTime(int maxDisplayTime) {
        this.maxDisplayTime = maxDisplayTime;
    }

    public String getDefaultResponse() {
        return this.defaultResponse;
    }

    public void setDefaultResponse(String defaultResponse) {
        this.defaultResponse = defaultResponse;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public char getInputType() {
        return this.inputType;
    }

    public void setInputType(char inputType) {
        this.inputType = inputType;
    }

    public char getEchoType() {
        return this.echoType;
    }

    public void setEchoType(char echoType) {
        this.echoType = echoType;
    }

    public int getAlertCode() {
        return this.alertCode;
    }

    public void setAlertCode(int alertCode) {
        this.alertCode = alertCode;
    }

    public static UserAlertManagementOperation getDisplay(String text) {
        return UserAlertManagementOperation.getDisplay(text, -1, -1);
    }

    public static UserAlertManagementOperation getDisplay(String text, int mindt, int maxdt) {
        return UserAlertManagementOperation.getUserAlert(1100, new String[]{text}, mindt, maxdt, null, -1, ' ', ' ');
    }

    public static UserAlertManagementOperation getConfirm(String text) {
        return UserAlertManagementOperation.getConfirm(text, -1, -1, null);
    }

    public static UserAlertManagementOperation getConfirm(String text, int mindt, int maxdt, String dr) {
        return UserAlertManagementOperation.getUserAlert(1101, new String[]{text}, mindt, maxdt, dr, -1, ' ', ' ');
    }

    public static UserAlertManagementOperation getInput(String text) {
        return UserAlertManagementOperation.getInput(text, -1, -1, null, -1, ' ', ' ');
    }

    public static UserAlertManagementOperation getInput(String text, int mindt, int maxdt, String dr, int maxlen, char it, char et) {
        return UserAlertManagementOperation.getUserAlert(1102, new String[]{text}, mindt, maxdt, dr, maxlen, it, et);
    }

    public static UserAlertManagementOperation getChoice(String text, String[] options) {
        return UserAlertManagementOperation.getChoice(text, options, -1, -1, null);
    }

    public static UserAlertManagementOperation getChoice(String text, String[] options, int mindt, int maxdt, String dr) {
        if (options == null || options.length == 0) {
            throw new IllegalArgumentException("options cannot be null or zero length");
        }
        String[] alerts = new String[options.length + 1];
        alerts[0] = text;
        System.arraycopy(options, 0, alerts, 1, options.length);
        return UserAlertManagementOperation.getUserAlert(1103, alerts, mindt, maxdt, dr, -1, ' ', ' ');
    }

    public static UserAlertManagementOperation getMultiChoice(String text, String[] options, int mindt, int maxdt, String dr) {
        if (options == null || options.length == 0) {
            throw new IllegalArgumentException("options cannot be null or zero length");
        }
        String[] alerts = new String[options.length + 1];
        alerts[0] = text;
        System.arraycopy(options, 0, alerts, 1, options.length);
        return UserAlertManagementOperation.getUserAlert(1104, alerts, mindt, maxdt, dr, -1, ' ', ' ');
    }

    protected static UserAlertManagementOperation getUserAlert(int alertCode, String[] alerts, int mindt, int maxdt, String dr, int maxlen, char it, char et) {
        return new UserAlertManagementOperation(alertCode, alerts, mindt, maxdt, dr, maxlen, it, et);
    }
}

