/*
 * Decompiled with CFR 0.152.
 */
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.vmguys.vmtools.ota.OtaUpdate;
import org.vmguys.vmtools.ota.UniqueId;
import org.vmguys.vmtools.utils.DomFactory;
import org.vmguys.vmtools.utils.ProgressReporter;

public class XmlDiff
implements ProgressReporter {
    private int greatestItemsProcessed;

    public static void main(String[] args) {
        if (args.length == 2) {
            try {
                URL url1 = new URL(args[0]);
                URL url2 = new URL(args[1]);
                new XmlDiff().go(url1, url2);
            }
            catch (MalformedURLException mux) {
                System.err.println(mux);
            }
        } else {
            System.err.println("usage: XmlDiff <OriginalURL> <ModifiedURL>");
        }
    }

    private void go(URL url1, URL url2) {
        try {
            SAXBuilder sb = new SAXBuilder();
            sb.setFactory((JDOMFactory)new DomFactory());
            System.out.println("parsing...");
            Document doc1 = sb.build(url1);
            Document doc2 = sb.build(url2);
            System.out.println("instantiating OtaUpdate...");
            OtaUpdate otaUpdate = new OtaUpdate(false);
            otaUpdate.setProgressReporter(this);
            this.greatestItemsProcessed = -1;
            UniqueId id = new UniqueId("Profile", "12345");
            System.out.println("generating diffs...");
            Element diffs = otaUpdate.generateDiffs(doc1.getRootElement(), doc2.getRootElement(), id);
            System.out.println("preparing to output diffs...");
            XMLOutputter xmlo = new XMLOutputter("  ", true);
            xmlo.setTextNormalize(true);
            System.out.println("outputting...");
            xmlo.output(diffs, (OutputStream)System.out);
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showProgress(int itemsProcessed, int totalItems) {
        if (itemsProcessed < totalItems) {
            int approxItemsProcessed = (itemsProcessed + 5) / 10 * 10;
            if (approxItemsProcessed > this.greatestItemsProcessed) {
                System.err.print("\r" + approxItemsProcessed + " of " + totalItems + " (" + itemsProcessed * 100 / totalItems + "%)   ");
                this.greatestItemsProcessed = approxItemsProcessed;
            }
        } else {
            System.err.print("\r" + itemsProcessed + " of " + totalItems + " (100%)   ");
            System.err.println();
        }
    }
}

