/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.log.Trace;
import org.jgroups.protocols.TunnelHeader;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.RouterStub;

public class TUNNEL
extends Protocol
implements Runnable {
    Properties properties = null;
    String channel_name = null;
    Vector members = new Vector();
    String router_host = null;
    int router_port = 0;
    Address local_addr = null;
    Thread receiver = null;
    RouterStub stub = null;

    public String toString() {
        return "Protocol TUNNEL(local_addr=" + this.local_addr + ")";
    }

    public String getName() {
        return "TUNNEL";
    }

    public void start() throws Exception {
        this.createTunnel();
        this.passUp(new Event(8, this.local_addr));
    }

    public void stop() {
        if (this.receiver != null) {
            this.receiver = null;
            if (this.stub != null) {
                this.stub.disconnect();
            }
        }
        this.teardownTunnel();
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("router_host");
        if (str != null) {
            this.router_host = new String(str);
            props.remove("router_host");
        }
        if ((str = props.getProperty("router_port")) != null) {
            this.router_port = new Integer(str);
            props.remove("router_port");
        }
        if (Trace.trace) {
            Trace.info("TUNNEL.setProperties()", "router_host=" + this.router_host + ";router_port=" + this.router_port);
        }
        if (this.router_host == null || this.router_port == 0) {
            Trace.error("TUNNEL.setProperties()", "both router_host and router_port have to be set !");
        }
        if (props.size() > 0) {
            StringBuffer sb = new StringBuffer();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                sb.append(e.nextElement().toString());
                if (!e.hasMoreElements()) continue;
                sb.append(", ");
            }
            Trace.error("TUNNEL.setProperties()", "The following properties are not recognized: " + sb.toString());
            return false;
        }
        return true;
    }

    public synchronized void down(Event evt) {
        if (Trace.trace) {
            Trace.info("TUNNEL.down()", "event is " + evt);
        }
        if (evt.getType() != 1) {
            this.handleDownEvent(evt);
            return;
        }
        TunnelHeader hdr = new TunnelHeader(this.channel_name);
        Message msg = (Message)evt.getArg();
        msg.putHeader(this.getName(), hdr);
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        if (!this.stub.send(msg, this.channel_name) && this.stub.reconnect()) {
            this.stub.register(this.channel_name);
        }
    }

    void createTunnel() throws Exception {
        if (this.router_host == null || this.router_port == 0) {
            throw new Exception("router_host and/or router_port not set correctly; tunnel cannot be created");
        }
        this.stub = new RouterStub(this.router_host, this.router_port);
        this.local_addr = this.stub.connect();
        if (this.local_addr == null) {
            throw new Exception("could not obtain local address !");
        }
    }

    synchronized void teardownTunnel() {
        if (this.stub != null) {
            this.stub.disconnect();
            this.stub = null;
        }
    }

    public void run() {
        if (this.stub == null) {
            Trace.error("TUNNEL.run()", "router stub is null; cannot receive messages from router !");
            return;
        }
        while (this.receiver != null) {
            Message msg = this.stub.receive();
            if (msg == null) {
                if (this.receiver == null) break;
                Trace.error("TUNNEL.run()", "received a null message. Trying to reconnect to router");
                if (!this.stub.reconnect()) continue;
                this.stub.register(this.channel_name);
                Trace.warn("TUNNEL.run()", "Reconnected!");
                continue;
            }
            this.handleIncomingMessage(msg);
        }
    }

    public void handleIncomingMessage(Message msg) {
        String ch_name;
        TunnelHeader hdr = (TunnelHeader)msg.removeHeader(this.getName());
        if (Trace.trace) {
            Trace.info("TUNNEL.handleIncomingMessage()", "received msg " + msg);
        }
        String string = ch_name = hdr != null ? hdr.channel_name : null;
        if (ch_name != null && !this.channel_name.equals(ch_name)) {
            return;
        }
        this.passUp(new Event(1, msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    Vector tmpvec = ((View)evt.getArg()).getMembers();
                    for (int i = 0; i < tmpvec.size(); ++i) {
                        this.members.addElement(tmpvec.elementAt(i));
                    }
                    break;
                }
            }
            case 7: {
                this.passUp(new Event(8, this.local_addr));
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 2: {
                this.channel_name = (String)evt.getArg();
                if (this.stub == null) {
                    Trace.error("TUNNEL.handleDownEvent()", "CONNECT:  router stub is null!");
                } else {
                    this.stub.register(this.channel_name);
                }
                this.receiver = new Thread((Runnable)this, "TUNNEL receiver thread");
                this.receiver.setDaemon(true);
                this.receiver.start();
                this.passUp(new Event(3));
                break;
            }
            case 4: {
                if (this.receiver != null) {
                    this.receiver = null;
                    if (this.stub != null) {
                        this.stub.disconnect();
                    }
                }
                this.teardownTunnel();
                this.passUp(new Event(5));
                this.passUp(new Event(8, null));
            }
        }
    }
}

