/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.core;

import java.util.HashMap;

public final class StatusCode {
    public static final int IN_PROGRESS = 101;
    public static final int OK = 200;
    public static final int ITEM_ADDED = 201;
    public static final int ACCEPTED_FOR_PROCESSING = 202;
    public static final int NONAUTHORITATIVE_RESPONSE = 203;
    public static final int NO_CONTENT = 204;
    public static final int RESET_CONTENT = 205;
    public static final int PARTIAL_CONTENT = 206;
    public static final int CONFLICT_RESOLVED_WITH_MERGE = 207;
    public static final int CONFLICT_RESOLVED_WITH_CLIENT_COMMAND_WINNING = 208;
    public static final int CONFLICT_RESOLVED_WITH_DUPLICATE = 209;
    public static final int DELETE_WITHOUT_ARCHIVE = 210;
    public static final int ITEM_NOT_DELETED = 211;
    public static final int AUTHENTICATION_ACCEPTED = 212;
    public static final int CHUNKED_ITEM_ACCEPTED = 213;
    public static final int OPERATION_CANCELLED = 214;
    public static final int NOT_EXECUTED = 215;
    public static final int ATOMIC_ROLLBACK_OK = 216;
    public static final int MULTIPLE_CHOICES = 300;
    public static final int MOVED_PERMANENTLY = 301;
    public static final int FOUND = 302;
    public static final int SEE_ANOTHER_URI = 303;
    public static final int NOT_MODIFIED = 304;
    public static final int USE_PROXY = 305;
    public static final int BAD_REQUEST = 400;
    public static final int INVALID_CREDENTIALS = 401;
    public static final int PAYMENT_REQUIRED = 402;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int COMMAND_NOT_ALLOWED = 405;
    public static final int OPTIONAL_FEATURE_NOT_SUPPORTED = 406;
    public static final int MISSING_CREDENTIALS = 407;
    public static final int REQUEST_TIMEOUT = 408;
    public static final int UPDATE_CONFLICT = 409;
    public static final int GONE = 410;
    public static final int SIZE_REQUIRED = 411;
    public static final int INCOMPLETE_COMMAND = 412;
    public static final int REQUESTED_ENTITY_TOO_LARGE = 413;
    public static final int URI_TOO_LONG = 414;
    public static final int UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int REQUESTED_SIZE_TOO_BIG = 416;
    public static final int RETRY_LATER = 417;
    public static final int ALREADY_EXISTS = 418;
    public static final int CONFLICT_RESOLVED_WITH_SERVER_DATA = 419;
    public static final int DEVICE_FULL = 420;
    public static final int UNKNOWN_SEARCH_GRAMMAR = 421;
    public static final int BAD_CGI_SCRIPT = 422;
    public static final int SOFT_DELETE_CONFLICT = 423;
    public static final int OBJECT_SIZE_MISMATCH = 424;
    public static final int PERMISSION_DENIED = 425;
    public static final int PARTIAL_ITEM_NOT_ACCEPTED = 426;
    public static final int ITEM_NOT_EMPTY = 427;
    public static final int MOVE_FAILED = 428;
    public static final int COMMAND_FAILED = 500;
    public static final int COMMAND_NOT_IMPLEMENTED = 501;
    public static final int BAD_GATEWAY = 502;
    public static final int SERVICE_UNAVAILABLE = 503;
    public static final int GATEWAY_TIMEOUT = 504;
    public static final int VERSION_NOT_SUPPORTED = 505;
    public static final int PROCESSING_ERROR = 506;
    public static final int ATOMIC_FAILED = 507;
    public static final int REFRESH_REQUIRED = 508;
    public static final int RECIPIENT_EXCEPTION_RESERVED1 = 509;
    public static final int DATASTORE_FAILURE = 510;
    public static final int SERVER_FAILURE = 511;
    public static final int SYNCHRONIZATION_FAILED = 512;
    public static final int PROTOCOL_VERSION_NOT_SUPPORTED = 513;
    public static final int OPERATION_CANCELLED_RECIPIENT = 514;
    public static final int ATOMIC_ROLLBACK_FAILED = 516;
    public static final int ATOMIC_RESPONSE_TOO_LARGE_TO_FIT = 517;
    public static final int SESSION_EXPIRED = 10000;
    public static final int SESSION_ABORTED = 20000;
    private static final HashMap<Integer, String> descriptions = new HashMap(71);

    public static String getStatusDescription(int n) {
        return descriptions.get(n);
    }

    private StatusCode() {
    }

    static {
        descriptions.put(101, "IN PROGRESS");
        descriptions.put(200, "OK");
        descriptions.put(201, "ITEM ADDED");
        descriptions.put(202, "ACCEPTED FOR PROCESSING");
        descriptions.put(203, "NONAUTHORITATIVE RESPONSE");
        descriptions.put(204, "NO CONTENT");
        descriptions.put(205, "RESET CONTENT");
        descriptions.put(206, "PARTIAL CONTENT");
        descriptions.put(207, "CONFLICT RESOLVED WITH MERGE");
        descriptions.put(208, "CONFLICT RESOLVED WITH CLIENT COMMAND WINNING");
        descriptions.put(209, "CONFLICT RESOLVED WITH DUPLICATE");
        descriptions.put(210, "DELETE WITHOUT ARCHIVE");
        descriptions.put(211, "ITEM NOT DELETED");
        descriptions.put(212, "AUTHENTICATION ACCEPTED");
        descriptions.put(213, "CHUNKED_ITEM_ACCEPTED");
        descriptions.put(214, "OPERATION CANCELLED");
        descriptions.put(215, "NOT EXECUTED");
        descriptions.put(216, "ATOMIC ROLLBACK OK");
        descriptions.put(300, "MULTIPLE CHOICES");
        descriptions.put(301, "MOVED PERMANENTLY");
        descriptions.put(302, "FOUND");
        descriptions.put(303, "SEE ANOTHER URI");
        descriptions.put(304, "NOT MODIFIED");
        descriptions.put(305, "USE PROXY");
        descriptions.put(400, "BAD REQUEST");
        descriptions.put(401, "INVALID CREDENTIALS");
        descriptions.put(402, "PAYMENT REQUIRED");
        descriptions.put(403, "FORBIDDEN");
        descriptions.put(404, "NOT FOUND");
        descriptions.put(405, "COMMAND NOT ALLOWED");
        descriptions.put(406, "OPTIONAL FEATURE NOT SUPPORTED");
        descriptions.put(407, "MISSING CREDENTIALS");
        descriptions.put(408, "REQUEST TIMEOUT");
        descriptions.put(409, "UPDATE CONFLICT");
        descriptions.put(410, "GONE");
        descriptions.put(411, "SIZE REQUIRED");
        descriptions.put(412, "INCOMPLETE COMMAND");
        descriptions.put(413, "REQUESTED ENTITY TOO LARGE");
        descriptions.put(414, "URI TOO LONG");
        descriptions.put(415, "UNSUPPORTED MEDIA TYPE");
        descriptions.put(416, "REQUESTED SIZE TOO BIG");
        descriptions.put(417, "RETRY LATER");
        descriptions.put(418, "ALREADY EXISTS");
        descriptions.put(419, "CONFLICT RESOLVED WITH SERVER DATA");
        descriptions.put(420, "DEVICE FULL");
        descriptions.put(421, "UNKNOWN SEARCH GRAMMAR");
        descriptions.put(422, "BAD CGI SCRIPT");
        descriptions.put(423, "SOFT DELETE CONFLICT");
        descriptions.put(424, "OBJECT_SIZE_MISMATCH");
        descriptions.put(425, "PERMISSION DENIED");
        descriptions.put(426, "PARTIAL ITEM NOT ACCEPTED");
        descriptions.put(427, "ITEM NOT EMPTY");
        descriptions.put(428, "MOVE FAILED");
        descriptions.put(500, "COMMAND FAILED");
        descriptions.put(501, "COMMAND NOT IMPLEMENTED");
        descriptions.put(502, "BAD GATEWAY");
        descriptions.put(503, "SERVICE UNAVAILABLE");
        descriptions.put(504, "GATEWAY TIMEOUT");
        descriptions.put(505, "VERSION NOT SUPPORTED");
        descriptions.put(506, "PROCESSING ERROR");
        descriptions.put(507, "ATOMIC FAILED");
        descriptions.put(508, "REFRESH REQUIRED");
        descriptions.put(509, "RECIPIENT EXCEPTION RESERVED1");
        descriptions.put(510, "DATASTORE FAILURE");
        descriptions.put(511, "SERVER FAILURE");
        descriptions.put(512, "SYNCHRONIZATION FAILED");
        descriptions.put(513, "PROTOCOL VERSION NOT SUPPORTED");
        descriptions.put(514, "OPERATION CANCELLED RECIPIENT");
        descriptions.put(516, "ATOMIC ROLLBACK FAILED");
        descriptions.put(517, "ATOMIC RESPONSE TOO LARGE TO FIT");
        descriptions.put(10000, "SESSION_EXPIRED");
        descriptions.put(20000, "SESSION_ABORTED");
    }
}

