/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.adapttcp;

import java.io.DataInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ReceiverThread
extends Thread {
    private long msgs_burst;
    private long num_bursts;
    private int msg_size;
    private int num_senders;
    Logger log = Logger.getLogger(this.getClass());
    long counter = 1L;
    long expected_msgs = this.msgs_burst * this.num_bursts * (long)this.num_senders;
    long beginning = 0L;
    long ending = 0L;
    long elapsed_time;
    long last_dump;
    long log_interval = 1000L;
    boolean gnuplot_output = Boolean.getBoolean("gnuplot_output");
    ServerSocket srv_sock;
    List receivers = new ArrayList();
    Object signal = new Object();
    Object counter_mutex = new Object();
    boolean done = false;
    boolean started = false;

    public ReceiverThread(ServerSocket srv_sock, long mb, int nb, int ms, int ns, long log_interval) {
        this.msgs_burst = mb;
        this.num_bursts = nb;
        this.msg_size = ms;
        this.num_senders = ns;
        this.expected_msgs = this.msgs_burst * this.num_bursts * (long)this.num_senders;
        this.log_interval = log_interval;
        this.srv_sock = srv_sock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        System.out.println("\nReceiver thread started...\n");
        this.counter = 1L;
        this.beginning = 0L;
        this.ending = 0L;
        if (this.gnuplot_output) {
            StringBuffer sb = new StringBuffer();
            sb.append("\n##### msgs_received");
            sb.append(", free_mem [KB] ");
            sb.append(", total_mem [KB] ");
            sb.append(", total_msgs_sec [msgs/sec] ");
            sb.append(", total_throughput [KB/sec] ");
            sb.append(", rolling_msgs_sec (last ").append(this.log_interval).append(" msgs) ");
            sb.append(" [msgs/sec] ");
            sb.append(", rolling_throughput (last ").append(this.log_interval).append(" msgs) ");
            sb.append(" [KB/sec]\n");
            this.log.info((Object)sb.toString());
        }
        Thread acceptor = new Thread(){

            public void run() {
                try {
                    while (true) {
                        Socket s = ReceiverThread.this.srv_sock.accept();
                        Receiver r = new Receiver(s);
                        r.setDaemon(true);
                        ReceiverThread.this.receivers.add(r);
                        r.start();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
            }
        };
        acceptor.setDaemon(true);
        acceptor.start();
        Object object = this.signal;
        synchronized (object) {
            while (!this.done) {
                try {
                    this.signal.wait();
                }
                catch (Exception ex) {}
            }
        }
        this.elapsed_time = this.ending - this.beginning;
        System.out.println("expected_msgs=" + this.expected_msgs + ", elapsed_time=" + this.elapsed_time);
        double throughput_s = (double)this.expected_msgs / ((double)this.elapsed_time / 1000.0);
        double throughput_b = (double)this.expected_msgs * ((double)this.msg_size / 1000.0) / ((double)this.elapsed_time / 1000.0);
        String result = "Received " + this.expected_msgs + " msgs. in " + this.elapsed_time + " msec.\n" + "Throughput: " + throughput_s + " [msgs/sec]\n" + "Throughput: " + throughput_b + " [KB/sec]\n" + "Total received: " + (double)this.expected_msgs * ((double)this.msg_size / 1000.0 / 1000.0) + " [MB]\n";
        System.out.println(result);
        this.log.info((Object)result);
    }

    String dumpStats(long received_msgs) {
        StringBuffer sb = new StringBuffer();
        if (this.gnuplot_output) {
            sb.append(received_msgs).append(" ");
        } else {
            sb.append("\nmsgs_received=").append(received_msgs);
        }
        if (this.gnuplot_output) {
            sb.append((double)Runtime.getRuntime().freeMemory() / 1000.0).append(" ");
        } else {
            sb.append(", free_mem=").append((double)Runtime.getRuntime().freeMemory() / 1000.0);
        }
        if (this.gnuplot_output) {
            sb.append((double)Runtime.getRuntime().totalMemory() / 1000.0).append(" ");
        } else {
            sb.append(", total_mem=").append((double)Runtime.getRuntime().totalMemory() / 1000.0).append("\n");
        }
        this.dumpThroughput(sb, received_msgs);
        return sb.toString();
    }

    void dumpThroughput(StringBuffer sb, long received_msgs) {
        long current = System.currentTimeMillis();
        double tmp = 1000L * this.counter / (current - this.beginning);
        if (this.gnuplot_output) {
            sb.append(tmp).append(" ");
        } else {
            sb.append("total_msgs_sec=").append(tmp).append(" [msgs/sec]");
        }
        tmp = received_msgs * (long)this.msg_size / (current - this.beginning);
        if (this.gnuplot_output) {
            sb.append(tmp).append(" ");
        } else {
            sb.append("\ntotal_throughput=").append(tmp).append(" [KB/sec]");
        }
        tmp = 1000L * this.log_interval / (current - this.last_dump);
        if (this.gnuplot_output) {
            sb.append(tmp).append(" ");
        } else {
            sb.append("\nrolling_msgs_sec (last ").append(this.log_interval).append(" msgs)=");
            sb.append(tmp).append(" [msgs/sec]");
        }
        tmp = this.log_interval * (long)this.msg_size / (current - this.last_dump);
        if (this.gnuplot_output) {
            sb.append(tmp).append(" ");
        } else {
            sb.append("\nrolling_throughput (last ").append(this.log_interval).append(" msgs)=");
            sb.append(tmp).append(" [KB/sec]\n");
        }
        this.last_dump = current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void done() {
        Object object = this.signal;
        synchronized (object) {
            System.out.println("** notify()");
            this.signal.notifyAll();
        }
    }

    class Receiver
    extends Thread {
        Socket sock;
        DataInputStream in;

        Receiver(Socket sock) throws Exception {
            this.sock = sock;
            sock.setSoTimeout(5000);
            this.in = new DataInputStream(sock.getInputStream());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.sock != null && ReceiverThread.this.counter < ReceiverThread.this.expected_msgs) {
                try {
                    this.readMessage(this.in);
                    Object object = ReceiverThread.this.counter_mutex;
                    synchronized (object) {
                        if (ReceiverThread.this.counter == 1L && !ReceiverThread.this.started) {
                            ReceiverThread.this.last_dump = ReceiverThread.this.beginning = System.currentTimeMillis();
                            ReceiverThread.this.started = true;
                        }
                        ++ReceiverThread.this.counter;
                        if (ReceiverThread.this.counter % 100L == 0L) {
                            System.out.println("-- received " + ReceiverThread.this.counter + " msgs");
                        }
                        if (ReceiverThread.this.counter % ReceiverThread.this.log_interval == 0L) {
                            ReceiverThread.this.log.info((Object)ReceiverThread.this.dumpStats(ReceiverThread.this.counter));
                        }
                        if (ReceiverThread.this.counter >= ReceiverThread.this.expected_msgs && !ReceiverThread.this.done) {
                            ReceiverThread.this.ending = System.currentTimeMillis();
                            Object object2 = ReceiverThread.this.signal;
                            synchronized (object2) {
                                ReceiverThread.this.done = true;
                                ReceiverThread.this.signal.notifyAll();
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    if (this.sock != null) break;
                    return;
                }
            }
        }

        void stopThread() {
            try {
                this.sock.close();
                this.sock = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void readMessage(DataInputStream in) throws Exception {
            int len = in.readInt();
            byte[] buf = new byte[len];
            in.readFully(buf, 0, len);
        }
    }
}

