/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.io;

import java.io.IOException;
import java.io.Writer;
import org.kxml.PrefixMap;
import org.kxml.Xml;
import org.kxml.io.AbstractXmlWriter;
import org.kxml.io.State;

public class XmlWriter
extends AbstractXmlWriter {
    protected Writer writer;
    private boolean pending = false;
    private int indentLevel = 0;
    private int noIndent = Integer.MAX_VALUE;
    static char[] indent = new char[]{'\r', '\n', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};

    public XmlWriter(Writer writer) {
        this.writer = writer;
    }

    protected void checkPending() throws IOException {
        if (this.pending) {
            this.writer.write(62);
            this.pending = false;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.checkPending();
        this.writer.flush();
    }

    public void write(char c) throws IOException {
        this.checkPending();
        if (this.noIndent > this.indentLevel) {
            this.noIndent = this.indentLevel;
        }
        switch (c) {
            case '<': {
                this.writer.write("&lt;");
                break;
            }
            case '>': {
                this.writer.write("&gt;");
                break;
            }
            case '&': {
                this.writer.write("&amp;");
                break;
            }
            default: {
                this.writer.write(c);
            }
        }
    }

    @Override
    public void write(char[] buf, int start, int len) throws IOException {
        int i;
        this.checkPending();
        if (this.noIndent > this.indentLevel) {
            this.noIndent = this.indentLevel;
        }
        int end = start + len;
        do {
            for (i = start; i < end && "<>&".indexOf(buf[i]) == -1; ++i) {
            }
            this.writer.write(buf, start, i - start);
            if (i == end) break;
            this.write(buf[i]);
        } while ((start = i + 1) < end);
    }

    public void writeCData(String buf) throws IOException {
        this.checkPending();
        if (this.noIndent > this.indentLevel) {
            this.noIndent = this.indentLevel;
        }
        this.writer.write("<![CDATA[");
        this.writer.write(buf);
        this.writer.write("]]>");
    }

    public void writeIndent() throws IOException {
        int l = this.indentLevel + 2;
        if (l < 2) {
            l = 2;
        } else if (l > indent.length) {
            l = indent.length;
        }
        this.checkPending();
        this.writer.write(indent, 0, l);
    }

    @Override
    public void attribute(String name, String value) throws IOException {
        if (!this.pending) {
            throw new RuntimeException("can write attr only immediately after a startTag");
        }
        this.writer.write(32);
        this.writer.write(name);
        this.writer.write("=\"");
        this.writer.write(Xml.encode(value, 1));
        this.writer.write(34);
        if (name.equals("xml:space") && value.equals("preserve")) {
            this.noIndent = this.indentLevel;
        }
    }

    @Override
    protected void startTag(PrefixMap prefixMap, String tag) throws IOException {
        this.current = new State(this.current, prefixMap, tag);
        this.checkPending();
        if (this.indentLevel < this.noIndent) {
            this.writeIndent();
        }
        ++this.indentLevel;
        this.writer.write(60);
        this.writer.write(tag);
        this.pending = true;
    }

    @Override
    public void endTag() throws IOException {
        --this.indentLevel;
        if (this.pending) {
            this.writer.write(" />");
            this.pending = false;
        } else {
            if (this.indentLevel + 1 < this.noIndent) {
                this.writeIndent();
            }
            this.writer.write("</");
            this.writer.write(this.current.tag);
            this.writer.write(">");
        }
        if (this.indentLevel + 1 == this.noIndent) {
            this.noIndent = Integer.MAX_VALUE;
        }
        this.current = this.current.prev;
        if (this.current == null) {
            throw new RuntimeException("too many closing tags!");
        }
    }

    @Override
    public void writeLegacy(int type, String content) throws IOException {
        this.checkPending();
        switch (type) {
            case 1: {
                this.writer.write("<!--");
                this.writer.write(content);
                this.writer.write("-->");
                break;
            }
            case 2: {
                this.writer.write("<!DOCTYPE ");
                this.writer.write(content);
                this.writer.write(">");
                break;
            }
            case 32: {
                this.writer.write("<?");
                this.writer.write(content);
                this.writer.write("?>");
            }
        }
    }

    public void writeRaw(String s) throws IOException {
        this.checkPending();
        this.writer.write(s);
    }
}

