/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.security;

import com.funambol.framework.tools.Base64;
import java.io.Serializable;
import java.security.Principal;

public class Sync4jPrincipal
implements Principal,
Serializable {
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_USERNAME = "username";
    public static final String PROPERTY_DEVICE = "device";
    private String id = null;
    private String username = null;
    private String deviceId = null;
    private String email = null;
    private String firstName = null;
    private String lastName = null;

    protected Sync4jPrincipal() {
    }

    public Sync4jPrincipal(String id, String username, String deviceId) {
        this.id = id;
        this.username = username;
        this.deviceId = deviceId;
    }

    public Sync4jPrincipal(String username, String deviceId) {
        this(null, username, deviceId);
    }

    public Sync4jPrincipal(String id) {
        this(id, null, null);
    }

    public static Sync4jPrincipal fromCredential(String userpwd, String type, String deviceId) throws IllegalArgumentException {
        Sync4jPrincipal ret = new Sync4jPrincipal();
        if ("syncml:auth-basic,syncml:auth-clear,syncml:auth-md5,syncml:auth-MAC".indexOf(type) < 0) {
            throw new IllegalArgumentException("Authorization type '" + type + "' not supported");
        }
        if ("syncml:auth-basic".equals(type)) {
            String s = new String(Base64.decode(userpwd.getBytes()));
            int p = s.indexOf(58);
            if (p == -1) {
                ret.setUsername(s);
            } else {
                ret.setUsername(p > 0 ? s.substring(0, p) : "");
            }
        } else if ("syncml:auth-clear".equals(type)) {
            String s = userpwd;
            int p = s.indexOf(58);
            if (p == -1) {
                ret.setUsername(s);
            } else {
                ret.setUsername(p > 0 ? s.substring(0, p) : "");
            }
        } else {
            ret.setUsername(userpwd);
        }
        ret.setId(null);
        ret.setDeviceId(deviceId);
        return ret;
    }

    @Override
    public String getName() {
        return this.deviceId == null ? this.username : this.username + '.' + this.deviceId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Sync4jPrincipal)) {
            return false;
        }
        return this.getName().equals(((Sync4jPrincipal)o).getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

