/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.vmguys.vmtools.utils.AbstractOperation;
import org.vmguys.vmtools.utils.DiffElement;

public class AttributeInsertOperation
extends AbstractOperation {
    private Attribute newAttr;

    public AttributeInsertOperation(DiffElement node, Attribute attr) {
        this(node, attr, null);
    }

    public AttributeInsertOperation(DiffElement node, Attribute attr, String Comment2) {
        this.node = node;
        this.newAttr = attr;
        this.comment = this.comment;
    }

    public Element asElement(Namespace namespace) {
        Element el = new Element("Attribute", namespace);
        el.setAttribute("Name", this.newAttr.getQualifiedName());
        el.setAttribute("Operation", "insert");
        el.setAttribute("Value", this.newAttr.getValue());
        if (this.comment != null) {
            Comment c = new Comment(this.comment);
            el.addContent(c);
        }
        return el;
    }

    public int cost() {
        return 1;
    }

    public String toString() {
        String cmt = this.comment == null ? "" : " (" + this.comment + ")";
        return "insert attribute " + this.newAttr.getQualifiedName() + " into node " + (Object)((Object)this.node);
    }

    public String getOperationXpath() throws JDOMException {
        return this.node.getXpath();
    }

    public int getOperationNodeNumber() {
        return this.node.getNodeNumber();
    }
}

