/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "treemanager/MOTreeCommand.h"
#include "executionqueue/IExecutionQueue.h"

namespace NS_DM_Client
{

class ProfileComponentsHolder;

namespace NS_DM_Diagnostics
{

class CollectDiagnosticsCommand : public MOTreeCommand
{
public:
    CollectDiagnosticsCommand(ProfileComponentsHolder* prholder, int duration, 
							  const String &serverID, const String &origID);
    virtual ~CollectDiagnosticsCommand();

    virtual bool Execute();

private:
    CollectDiagnosticsCommand(const CollectDiagnosticsCommand&);
    CollectDiagnosticsCommand& operator =(const CollectDiagnosticsCommand&);

    ProfileComponentsHolder* m_prholder;
	int m_duration;
	String m_serverID;
	String m_origID;
};


}
}
