/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "commontypes.h"
#include "DeviceAdapter/FirmwareUpdate/IFirmwareUpdater.h"


namespace NS_DM_Client
{
	class DiskStorageFirmwareUpdater : public IFirmwareUpdater
	{
	public:
		DiskStorageFirmwareUpdater();
		virtual ~DiskStorageFirmwareUpdater();

		virtual bool Init(NS_Logging::Logger* logger);
		virtual bool Init(const char* defFWPackageName, const char* defFWStorageLocation,
			bool noCleanStorage, NS_Logging::Logger* logger);

		virtual EnumFirmwareStatus InitStorage(const char* packageName = 0, const char* location = 0);
		virtual EnumFirmwareStatus ResetStorage();
		virtual EnumFirmwareStatus AppendChunk(const char* buffer, size_t size, bool last);
		virtual EnumFirmwareStatus Update();

	protected:
		virtual bool isFWStorageInitialised() const;

		virtual bool generateFWUpdatedIndicator(String& ind);
		virtual bool setFWUpdatedIndication();
		virtual bool resetFWUpdatedIndication();

	protected:
		NS_Logging::Logger* m_logger;

		String m_fwDefLocation; // default location for firmware
		String m_fwPackageDefName; // firmware package default name
		String m_fwPackageName; // firmware package name

		FILE* m_fwPkgStorage;
		size_t m_pkgSize;

		bool m_lastFWChunk;
		bool m_notCleanStorage;

	public:
		bool m_fwUpdateFailure;
	};
}


