/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <platform.h>
#include <vector>
#include <commontypes.h>
#include <CryptoAPI/ICrypto.h>
#include <Logger/Logger.h>

namespace NS_DM_Client
{

namespace NS_NotificationListener
{

    class BootstrapMessage
    {
    public:
        BootstrapMessage(NS_Logging::Logger& logger);
        ~BootstrapMessage();

        enum EnumHeaderSize
        {
            e_VersionSize = 2,
            e_ProtocolSize = 2,
            e_LengthSize = 4,

            e_HeaderSize = e_VersionSize + e_ProtocolSize + e_LengthSize
        };

        enum EnumProtocol
        {
            e_OMA_DM    = 0,
            e_TR_069    = 1
        };

        enum EnumVersion
        {
            e_Version = 0
        };
#pragma pack(push,1)
        struct HEADER
        {
            uint16_t    version;
            uint16_t    protocol;
            union
            {
                uint32_t    data_length;
                uint8_t     _len_data[sizeof(uint32_t) / sizeof(uint8_t)];
            };

            void ntoh()
            {
#ifdef PLT_LITTLE_ENDIAN
                version = (version >> 8) | (version << 8);
                protocol = (protocol >> 8) | (protocol << 8);
                data_length = (_len_data[0] << 8*3) | (_len_data[1] << 8*2) | (_len_data[2] << 8) | _len_data[3];
#endif
            }
        };

        struct TLV_HEADER
        {
            uint16_t    type;
            union
            {
                uint32_t    length;
                uint8_t     _len_data[sizeof(uint32_t) / sizeof(uint8_t)];
            };

            void ntoh()
            {
#ifdef PLT_LITTLE_ENDIAN
                type = (type >> 8) | (type << 8);
                length = (_len_data[0] << 8*3) | (_len_data[1] << 8*2) | (_len_data[2] << 8) | _len_data[3];
#endif
            }
        };
#pragma pack(pop)

        enum EnumTLVTypes
        {
            e_Nonce = 0,
            e_Ciphertext = 1
        };

        // Bootstrap Information Protection constants
        static const int c_Tlen;
        static const int c_t;

        void    SetEMSK(const void* key, size_t key_size);
        void    SetBEK(const void* key, size_t key_size);

        bool    Decode(const void* data, size_t datasize, bool plain, bool cipherHeaderPresent, buffer_t& decoded);

    private:
		ICrypto *m_pCrypto;
        buffer_t    m_BEK;
#ifdef PLT_LITTLE_ENDIAN
        buffer_t    m_message;
#endif

		NS_Logging::Logger& m_logger;
    };

}

}

