/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <daemon/Profile.h>
#include <daemon/IComponent.h>

namespace NS_DM_Client
{

namespace NS_Daemon
{

    class ComponentStarter
    {
    public:
        typedef NS_Daemon::Profile::Components  Components;
        ComponentStarter(Components& comp)
            : m_allStarted(true), m_comps(comp)
        {}

        bool operator() (IComponent* c)
        {
            bool started = c->Start();
            if (started)
            {
                m_comps.push_back(c);
            }
            else
            {
                m_allStarted = false;
            }

            return !started;
        }

        bool IsAllStarted() const
        { return m_allStarted; }

    private:
        bool    m_allStarted;
        Components& m_comps;

    };


    class ComponentStoper
    {
    public:
        ComponentStoper()
        {}

        bool operator() (IComponent* c)
        {
            return c->Stop();
        }

    };

}



}
