/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "CritSection.h"
#include "serverexchange/wrappers/SCommandAdapter.h"

namespace NS_DM_Client
{
	namespace NS_SyncMLCommand
	{
		class CommandStorage
		{
		public:
			CommandStorage();
			~CommandStorage();

			void Add(NS_SyncMLCommand::SCommandPtr);
			void Clear();
			void InsertFirst(NS_SyncMLCommand::SCommandPtr);
			void Remove(const char * msgid, const char * cmdid, const char *cmdname);
			int  Size();

			bool Lock()    { m_sc.Lock(); return true; }
			int  TryLock() { return m_sc.TryLock(); }
			void Unlock()  { m_sc.Unlock(); }

			NS_SyncMLCommand::SCommandPtr operator[] (unsigned int);

		private:
			typedef std::vector<NS_SyncMLCommand::SCommandPtr> SCommands;
			SCommands m_commands;
			NS_Common::CritSection m_sc;
		};
	}
}
