#include "MessageSerializer.h"
#include "Message.h"
#include "common/Utils.h"

namespace NS_DM_Client
{
	MessageSerializer::MessageSerializer()
	{

	}
	//-------------------------------------------------------------------------------------------

	const MessageSerializer::PlainData& MessageSerializer::operator()(const Message& message)
	{
		size_t requiredSize = Message::GetHeaderSize() + message.m_data.size();/*data*/
		m_buffer.resize(requiredSize);

		size_t curPos = 0;
		size_t msgId = message.m_id;
		memcpy(&m_buffer[curPos], &msgId, sizeof(size_t));
		curPos += sizeof(size_t);

		size_t msgType = message.m_type;
		memcpy(&m_buffer[curPos], &msgType, sizeof(size_t));
		curPos += sizeof(size_t);

		size_t msgSubType = message.m_subType;
		memcpy(&m_buffer[curPos], &msgSubType, sizeof(size_t));
		curPos += sizeof(size_t);

		size_t size = message.m_data.size();
		memcpy(&m_buffer[curPos], &size, sizeof(size_t));
		curPos += sizeof(size_t);

		if (size != 0)
			memcpy(&m_buffer[curPos], &(message.m_data[0]), size);

		return m_buffer;
	}
	//-------------------------------------------------------------------------------------------

	const String S_seperator("*");
	void AppendString(const String& str, String& data)
	{
		data.append(ToString(str.size()));
		data.append(S_seperator);
		data.append(str);
	}
	//-------------------------------------------------------------------------------------------

	void SerializeOperatorProfile(const String& name, const String& type, const String& description, String& data)
	{
		AppendString(name, data);
		AppendString(type, data);
		AppendString(description, data);
	}
	//-------------------------------------------------------------------------------------------

	void SerializeConfirmationResponse(const String& requestMessage, size_t confCode, String& data)
	{
		AppendString(requestMessage, data);
		data.append(ToString(confCode));
	}
	//-------------------------------------------------------------------------------------------

	void SerializeDMSessionNotification(EventType eventType, Initiator initiator, NotificationStatus statusCode, String& data)
	{
		data.append(ToString(eventType));
		data.append(S_seperator);
		data.append(ToString(initiator));
		data.append(S_seperator);
		data.append(ToString(statusCode));
	}
	//-------------------------------------------------------------------------------------------

	void SerializeFirmwareInfo(const String& localpath, const String& filename, int size, String& data)
	{
		AppendString(localpath, data);
		AppendString(filename, data);
		data.append(ToString(size));
	}
	//-------------------------------------------------------------------------------------------

	void SerializePasswords(const String& oldPassword, const String& newPassword, String& data)
	{
		AppendString(oldPassword, data);
		AppendString(newPassword, data);
	}

	//-------------------------------------------------------------------------------------------

	void SerializePasswordsAndServerID(const String& serverID, const String& oldPassword, const String& newPassword, String& data)
	{
		AppendString(serverID, data);
		SerializePasswords(oldPassword, newPassword, data);
	}

}
