#include "common/Utils.h"
#include "ClientAdapter/ProvisionInfo.h"

namespace NS_DM_Client
{
	const String S_seperator("*");

	ProvisionInfoRequest::ProvisionInfoRequest(const String URI, bool monitorChildren, int commands, int events):
		m_URI(URI), m_monitorChildren(monitorChildren), m_commands(commands), m_events(events)
	{

	}
	//-------------------------------------------------------------------------------------------

	void ProvisionInfoRequest::Serialize(String& data) const
	{
		data.clear();
		size_t uriSize = m_URI.size();
		data.append(ToString(uriSize));
		data.append(S_seperator);
		data.append(m_URI);
		data.append(ToString(m_monitorChildren));
		data.append(S_seperator);
		data.append(ToString(m_commands));
		data.append(S_seperator);
		data.append(ToString(m_events));
		data.append(S_seperator);
	}
	//-------------------------------------------------------------------------------------------

	bool ProvisionInfoRequest::Deserialize(const String& data)
	{
		size_t seperatorPos = data.find_first_of(S_seperator);
		size_t curPos = seperatorPos;
		String strUriSize = data.substr(0, curPos);
		size_t uriSize = atoi(strUriSize.c_str());
		curPos += S_seperator.size(); /*skip seperator*/
		m_URI = data.substr(curPos, uriSize);
		curPos += uriSize;

		seperatorPos = data.find(S_seperator, curPos);
		String strMonitorChildren = data.substr(curPos, seperatorPos - curPos);
		m_monitorChildren = atoi(strMonitorChildren.c_str()) != 0;
		curPos = seperatorPos + S_seperator.size(); /*skip seperator*/

		seperatorPos = data.find(S_seperator, curPos);
		String strCommand = data.substr(curPos, seperatorPos - curPos);
		m_commands = (CommandType)atoi(strCommand.c_str());
		curPos = seperatorPos + S_seperator.size(); /*skip seperator*/

		seperatorPos = data.find(S_seperator, curPos);
		String strEvent = data.substr(curPos, seperatorPos - curPos);
		m_events = (EventType)atoi(strEvent.c_str());
		curPos = seperatorPos + S_seperator.size(); /*skip seperator*/

		return true;
	}
	//-------------------------------------------------------------------------------------------

	ProvisionInfoResponse::ProvisionInfoResponse() 
	{

	}
	//-------------------------------------------------------------------------------------------

	ProvisionInfoResponse::ProvisionInfoResponse(const StringArray& URIs, CommandType command, EventType event, StatusCode statusCode):
		m_URIs(URIs), m_command(command), m_event(event), m_statusCode(statusCode)	
	{
	}
	//-------------------------------------------------------------------------------------------

	void ProvisionInfoResponse::Serialize(String& data) const
	{
		data.clear();
		// uriCount * sizeUri1 * uri1 sizeUri2 * uri2 command * event *
		size_t uriCount = m_URIs.size();
		data.append(ToString(uriCount));
		data.append(S_seperator);

		for (size_t i = 0; i != uriCount; ++i)
		{
			size_t uriSize = m_URIs[i].size();
			data.append(ToString(uriSize));
			data.append(S_seperator);
			data.append(m_URIs[i]);
		}
		
		data.append(ToString(m_command));
		data.append(S_seperator);
		data.append(ToString(m_event));
		data.append(S_seperator);
		data.append(ToString(m_statusCode));
	}
	//-------------------------------------------------------------------------------------------

	bool ProvisionInfoResponse::Deserialize(const String& data)
	{
		size_t seperatorPos = data.find_first_of(S_seperator);
		size_t curPos = seperatorPos + S_seperator.size();

		String strUriCount = data.substr(0, curPos);
		size_t uriCount = atoi(strUriCount.c_str());

		for (size_t i = 0; i != uriCount; ++i)
		{
			seperatorPos = data.find(S_seperator, curPos);
			String strUriSize = data.substr(curPos, seperatorPos - curPos);
			size_t uriSize = atoi(strUriSize.c_str());
			curPos = seperatorPos + S_seperator.size(); /*skip seperator*/
			String URI = data.substr(curPos, uriSize);
			m_URIs.push_back(URI);
			curPos += uriSize;
		}
		
		seperatorPos = data.find(S_seperator, curPos);
		String strCommand = data.substr(curPos, seperatorPos - curPos);
		m_command = (CommandType)atoi(strCommand.c_str());
		curPos = seperatorPos + S_seperator.size(); /*skip seperator*/

		seperatorPos = data.find(S_seperator, curPos);
		String strEvent = data.substr(curPos, seperatorPos - curPos);
		m_event = (EventType)atoi(strEvent.c_str());
		curPos = seperatorPos + S_seperator.size(); /*skip seperator*/

		seperatorPos = data.find(S_seperator, curPos);
		String strStatusCode = data.substr(curPos, seperatorPos - curPos);
		m_statusCode = (StatusCode)atoi(strStatusCode.c_str());
		curPos += sizeof(size_t);

		return true;
	}
}