/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#ifndef DATASTORAGEDEFS_H_INCLUDED
#define DATASTORAGEDEFS_H_INCLUDED

#include "commontypes.h"
#include "FileSystemUtils.h"


namespace NS_DM_Client
{

namespace NS_DataStorage
{

const char* const c_privateDataPath = "%ALLUSERSPROFILE%/Funambol/DMClient/DataStorage";
const char* const c_streamSubPath = "/streams";

const char* const c_confFile = "conf/conf";
const char* const c_streamFileTemplate = "streams/stream_";

const char c_pathSeparator = '/';
const char* const c_pathSeparatorStr = "/";
const char* const c_pathEmptyStr = "";

const char* const c_separatorReplacing = "%%";

const char* const c_privateDataExt = ".priv";
const char* const c_streamDataExt = ".strm";

const long c_MaxStreamNumber = 1000;

const char* const c_DataStorageLog = "DataStorage";
const char* const c_StreamHandlerLog = "StreamHandler";

void str_replace(String& src, const String& what, const String& with);

bool ExpandStringWithEnvironmentVars(const String& in, String& out);

}

}

#endif // DATASTORAGEDEFS_H_INCLUDED
