/*
 *  UT_Utils.cpp
 *  OMA-DM Client
 *
 *  Created by Mykola Bilovus on 03/03/10.
 *  Copyright 2010. All rights reserved.
 *
 */


#include <boost/test/unit_test.hpp>
#include "common/Utils.h"


using namespace NS_DM_Client;


BOOST_AUTO_TEST_SUITE(SuiteCommonLib)


BOOST_AUTO_TEST_CASE(TestCase_CreateNonce)
{
	Funambol::NextNonce *pNonce = CreateNonce();
	
	BOOST_CHECK( pNonce != NULL );
	BOOST_CHECK( pNonce->getValueSize() > 0 );
	
	const char *pB64Nonce = pNonce->getValueAsBase64();
	BOOST_CHECK( pB64Nonce != NULL );
	BOOST_CHECK( strlen(pB64Nonce) > 0 );
	
	delete pB64Nonce;
	delete pNonce;
}

/*
BOOST_AUTO_TEST_CASE(TestCase_IsBooleanTrue)
{
	BOOST_CHECK( IsBooleanTrue(String("1"))    );
	BOOST_CHECK( IsBooleanTrue(String("true")) );
	BOOST_CHECK( IsBooleanTrue(String("TRUE")) );

	BOOST_CHECK( !IsBooleanTrue(String("sdsd"))    );
	BOOST_CHECK( !IsBooleanTrue(String("0")) );
	BOOST_CHECK( !IsBooleanTrue(String("false")) );
	BOOST_CHECK( !IsBooleanTrue(String("FALSE")) );
}
*/

BOOST_AUTO_TEST_CASE(TestCase_ToString)
{
	BOOST_CHECK( ToString( 0)    == "0"     );
	BOOST_CHECK( ToString(-1)    == "-1"    );
	BOOST_CHECK( ToString(65900) == "65900" );
}


BOOST_AUTO_TEST_SUITE_END()
