/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "treemanager/FUMORefUpdateListener.h"
#include "../Node.h"

static const char* listen_uri = "./WiMAX/WiMAXRadioModule/X/TO-FUMO-REF";
static const char* diff_key = "X";
static const size_t diff_ins_pos = 25;

namespace NS_DM_Client
{

FUMORefUpdateListener::FUMORefUpdateListener(ProfileComponentsHolder& pch) : m_component_holder(pch)
{

}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::Init(ProfileComponentsHolder& pch)
{
    return true;
}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::Release()
{
    delete this;
    return true;
}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::ExecuteOnAdd(const URI& uri)
{
    if (isListenURI(uri))
    {
        if (!m_component_holder.GetDataStorage())
        {
            return false;
        }

        Node node(uri, m_component_holder.GetDataStorage());
        if (node.Exist() && node.IsLeaf())
        {
            String value;
            if (node.GetContent(value))
            {
                if (value.empty())
                {
                    node.SetContent(m_defValue);
                }
            }
        }
    }

    return true;
}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::ExecuteOnDelete(const URI& uri)
{
    // nothing to do
    return true;
}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::ExecuteOnReplace(const URI& uri)
{
    // nothing to do
    return true;
}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::ExecuteOnReplaceProperty(const URI& uri, const String& property_name)
{
    // nothing to do
    return true;
}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::ExecuteOnCopy(const URI& source, const URI& dest)
{
    // nothing to do
    return true;
}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::isListenURI(const URI& uri) const
{
    if (uri.length() >= strlen(listen_uri))
    {
        URI merged_uri = uri.substr(0, diff_ins_pos) + (URI)diff_key + uri.substr(diff_ins_pos + 1);
        return (merged_uri.compare(listen_uri) == 0) ? true : false;
    }
    return false;
}

//-------------------------------------------------------------------------------------------

bool FUMORefUpdateListener::SetDefaultValue(const String& defValue)
{
    m_defValue = defValue;
    return true;
}

}
