/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#pragma once

#include "commontypes.h"
#include "platform.h"

#ifdef PLATFORM_LINUX
#define CLIENTADAPTER_API
#elif defined(PLATFORM_WINDOWS)
#ifdef CLIENTADAPTER_EXPORTS
#define CLIENTADAPTER_API __declspec(dllexport)
#else
#define CLIENTADAPTER_API __declspec(dllimport)
#endif // CLIENTADAPTER_EXPORTS
#else
#define CLIENTADAPTER_API
#endif

namespace NS_DM_Client
{
	class DevInfo;
	class DevDetail;
	class DMAcc;
	class WiMAX;
	class WiMAXSupp;
	class INotificationUpdater;
	namespace NS_DM_Diagnostics
	{
		class WiMAX_Diagnostics;
	}

	class ClientProfileInfo
	{
	public:
		String m_name;
		String m_description;
	};

	enum MOType
	{
		e_NotWellKnownMO,

		e_MODevInfo,
		e_MODevDetail,
		e_MODMAcc,

	};

	class IClientAdapter
	{
	public:
		virtual ~IClientAdapter() {};
		virtual bool Open() = 0; // open connection to DMClient
		virtual bool Close() = 0; // close connection to DMClient
		virtual void Release() = 0;

		virtual bool GetClientProfiles(std::vector<ClientProfileInfo>& profiles) = 0;
		virtual bool SwitchClientProfile(const String& profileName) = 0;

		virtual bool HandleNetworkEntry(int homeNspID, const char* operatorName) = 0;

		virtual bool GetDeviceInfo(DevInfo& deviceInfo) = 0;
		virtual bool GetDeviceDetail(DevDetail& deviceDetail) = 0;
		virtual bool GetDMAccount(DMAcc& dmAccount) = 0;
		virtual bool GetWiMAX(WiMAX& wimax) = 0;
		virtual bool GetWiMAXSupp(WiMAXSupp& wimaxSupp) = 0;

		virtual bool SetDeviceInfo(const DevInfo& deviceInfo) = 0;
		virtual bool SetDeviceDetail(const DevDetail& deviceDetail) = 0;
		virtual bool SetDMAccount(const DMAcc& dmAccount) = 0;
		virtual bool SetWiMAX(const WiMAX& wimax) = 0;
		virtual bool SetWiMAXSupp(const WiMAXSupp& wimaxSupp) = 0;
		virtual bool SetWiMAXDiagnostics(const NS_DM_Diagnostics::WiMAX_Diagnostics& wimaxDiagnostics) = 0;
		
		virtual bool DRMDReady() = 0;

		virtual bool StartDMSession(INotificationUpdater* updater) = 0;
		virtual bool CheckForFirmwareUpdate(INotificationUpdater* updater) = 0;

		virtual bool SubscribeToDMSessionNotif(INotificationUpdater* updater) = 0;
		virtual bool SubscribeToFirmwareUpdateNotif(INotificationUpdater* updater) = 0;
		virtual bool SubscribeToProvisioningUpdateNotif(INotificationUpdater* updater) = 0;
		virtual bool SubscribeToDRMDNotif(INotificationUpdater* updater) = 0;

		virtual bool UnsubscribeToDMSessionNotif(INotificationUpdater* updater) = 0;
		virtual bool UnsubscribeToFirmwareUpdateNotif(INotificationUpdater* updater) = 0;
		virtual bool UnsubscribeToProvisioningUpdateNotif(INotificationUpdater* updater) = 0;

		virtual bool SetMgmtTree(const String& mgmtTree) = 0;
		virtual bool GetMgmtTree(const String& uri, String& mgmtTree) = 0;

		virtual bool SetEMSK(const void* buffer, size_t count) = 0;
		virtual bool SetDeviceID(const void* buffer, size_t count) = 0;
	};
}
extern "C" CLIENTADAPTER_API void* CreateClientAdapter();

