/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include "UserInteractionDefs.h"

namespace NS_DM_Client
{

class IMessageHandler
{
public:
    virtual bool Init() = 0;
    virtual bool Release() = 0;

    //------------------------------------------------------------------------------------------------------
    // e_Ok - display message
    virtual StatusCode Display(const char* message, long min_time, long max_time) = 0;
    //------------------------------------------------------------------------------------------------------
    // e_Ok - user choise "Yes"
    // e_OperationCancelled:
    //  - user cancel
    //  - user choise "No"
    //  - max_time is spent
    virtual StatusCode Confirmation(const char* message, long min_time, long max_time) = 0;
    //------------------------------------------------------------------------------------------------------
    // e_Ok - user type input
    // e_OperationCancelled:
    //  - user cancel
    //  - max_time is spent
    virtual StatusCode UserInput(const char* message, long min_time, long max_time, char*& input,
        // max_len - maximum user input lenght
        // echo_password - input echo type set as password input or not
        long* max_len = 0, bool echo_password = 0) = 0;
    //------------------------------------------------------------------------------------------------------
    // e_Ok - user set chiose
    // e_OperationCancelled:
    //  - user cancel
    //  - max_time is spent
    virtual StatusCode UserChoice(const char* message, long min_time, long max_time,
        // avialable_choise_set - avialable choise set separated by "-"
        // choise_set - user choise set separated by "-"
        const char* avialable_choise_set, char*& choise_set, bool allowMultipleChoises) = 0;
    //------------------------------------------------------------------------------------------------------
    // e_Ok - progress is displayed
    // e_OperationCancelled:
    //  - user cancel

    // size_to_download:
    //  > 0 - size in bytes download needed
    //  = 0 - download is finished
    //  < 0 - download is terminated from the side of server
    virtual StatusCode ProgressNotification(const char* message, long min_time, long max_time,
        // size in bytes download needed
        long size_to_download) = 0;
    //------------------------------------------------------------------------------------------------------

    virtual void ReleaseString(char* str) = 0;

    virtual ~IMessageHandler() { }
};

}
