/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include "commontypes.h"
#include "IMgmtObject.h"

namespace NS_DM_Client
{
	class IMOTreeManager;
	class TNDSCreator;
	class TNDSExtractor;

	typedef unsigned char UINT8;
	typedef unsigned short USHORT;

	struct MANAGEMENTOBJECTS_API CAPLEntries
	{
		CAPLEntries(): m_NAP_ID(0), m_Priority(0) {}

		size_t m_NAP_ID;
		size_t m_Priority;
		std::vector<String> m_ChPlanRefIds;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API CAPL
	{
		CAPL(): m_Any(0) {}

		std::vector<CAPLEntries> m_Entries;
		size_t m_Any;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct RAPLEntries
	{
		RAPLEntries(): m_V_NSP_ID(0), m_Priority(0) {}

		size_t m_V_NSP_ID;
		size_t m_Priority;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct RAPL
	{
		RAPL(): m_Any(0) {}

		std::vector<RAPLEntries> m_Entries;
		size_t m_Any;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct ChannelPlanEntries
	{
		ChannelPlanEntries(): m_FirstFreq(0), m_LastFreq(0), m_NextFreqStep(0), m_BW(0),
			m_FFTSize(0), m_DuplexMode(0) {}

		String m_Id;
		size_t m_FirstFreq;
		size_t m_LastFreq;
		size_t m_NextFreqStep;
		String m_Preambles;
		size_t m_BW;
		size_t m_FFTSize;
		size_t m_DuplexMode;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API ChannelPlan
	{
		ChannelPlan(): m_BW(0), m_FFTSize(0), m_DuplexMode(0) {}

		std::vector<ChannelPlanEntries> m_Entries;
		size_t m_BW;
		size_t m_FFTSize;
		size_t m_DuplexMode;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};
	//-------------------------------------------------------------------------------------------

	struct MANAGEMENTOBJECTS_API NetworkParameters
	{
		NetworkParameters(): m_PollingInterval(0) {}

		std::vector<size_t> m_H_NSP;
		CAPL m_CAPL;
		RAPL m_RAPL;
		ChannelPlan m_ChannelPlan;
		String m_OperatorName;
		size_t m_PollingInterval;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API CERT
	{
		CERT(): m_SER_NUM(0), m_THUMBPRINT(0) {}

		String m_CERT_TYPE;
		size_t m_SER_NUM;
		size_t m_THUMBPRINT;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API EAP
	{
		EAP(): m_METHOD_TYPE(0), m_VENDOR_ID(0), m_VENDOR_TYPE(0), m_USE_PRIVACY(0), m_ENCAPS(0),
			m_VFY_SERVER_REALM(0), m_EAP_AKA(0) {}

		size_t m_METHOD_TYPE;
		size_t m_VENDOR_ID;
		size_t m_VENDOR_TYPE;
		String m_UserIdentity;
		String m_PROVISIONED_PSEUDO_IDENTITY;
		String m_PASSWORD;
		String m_REALM;
		UINT8 m_USE_PRIVACY;
		size_t m_ENCAPS;
		size_t m_VFY_SERVER_REALM;
		std::vector<String> m_SERVER_REALMS;
		size_t m_EAP_AKA;
		std::vector<CERT> m_CERT;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API Primary
	{
		Primary(): m_Activated(0) {}

		String m_Name;
		size_t m_Activated;
		std::vector<EAP> m_EAP;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API OtherSubscriptions
	{
		OtherSubscriptions(): m_Activated(0) {}

		String m_Name;
		size_t m_Activated;
		std::vector<EAP> m_EAP;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API SubscriptionParameters
	{
		Primary m_Primary;
		std::vector<OtherSubscriptions> m_OtherSubscriptions;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API RootCA
	{
		String m_CertID;
		String m_Signature;
		String m_Certificate;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API Contacts
	{
		Contacts(): m_Type(0) {}

		size_t m_Type;
		String m_Trigger;
		String m_URI;
		String m_Text;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API Operator
	{
		NetworkParameters m_NetworkParameters;
		SubscriptionParameters  m_SubscriptionParameters;
		std::vector<RootCA> m_RootCA;
		std::vector<Contacts> m_Contacts;
		String m_TO_IP_REF;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	class MANAGEMENTOBJECTS_API WiMAXSupp: public IMgmtObject
	{
	public:
		String m_defaultOperator;
		String m_identify; // "primary" or "0", "1"
		typedef String OperatorName;
		typedef std::map<OperatorName, Operator> Operators;
		Operators m_Operator;

	public:
		virtual bool Serialize(IMOTreeManager& treeManager) const;
		virtual bool Deserialize(IMOTreeManager& treeManager);

		virtual bool Serialize(String& xml) const;
		virtual bool Deserialize(const String& xml);
	};
}
