/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include "platform.h"

#ifdef PLATFORM_LINUX
	#define CLIENT_ADAPTER_API
#elif defined(PLATFORM_WINDOWS)
	#ifdef CLIENT_ADAPTER_EXPORTS
		#define CLIENT_ADAPTER_API __declspec(dllexport)
	#else
		#define CLIENT_ADAPTER_API __declspec(dllimport)
	#endif // CLIENT_ADAPTER_EXPORTS
#else
	#define CLIENT_ADAPTER_API
#endif


namespace NS_DM_Client
{
	struct DevInfo;
	struct DevDetail;
	struct DMAcc;
	struct WiMAX;
	struct WiMAXSupp;

      class IClientAdapter
      {
      public:
            virtual ~IClientDevice() = 0;
            virtual bool Open() = 0;
            virtual bool Start() = 0;
            virtual bool Close() = 0;

            virtual bool GetDeviceInfo(DevInfo& deviceInfo) = 0;
            virtual bool GetDeviceDetail(DevDetail& deviceDetail) = 0;
            virtual bool GetDMAccount(DMAcc& dmAccount) = 0;
            virtual bool GetWiMAX(WiMAX& wimax) = 0;
            virtual bool GetWiMAXSupp(WiMAXSupp& wimaxSupp) = 0;

            virtual bool SetDeviceInfo(const DevInfo& deviceInfo) = 0;
            virtual bool SetDeviceDetail(const DevDetail& deviceDetail) = 0;
            virtual bool SetDMAccount(const DMAcc& dmAccount) = 0;
            virtual bool SetWiMAX(const WiMAX& wimax) = 0;
            virtual bool SetWiMAXSupp(const WiMAXSupp& wimaxSupp) = 0;

            virtual bool UpdateFUMO() = 0;
            virtual bool CheckFUMO() = 0;      // check if FUMO updates exist on server
            virtual bool DownloadFUMO() = 0;   // request download FUMO updates from server
            virtual bool GetOperatorProfile() = 0;
      };

}

extern "C" CLIENT_ADAPTER_API void* CreateClientAdapter(long param);
