/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include <NotificationListener/IDataSink.h>
#include <IRunner.h>
#include <commontypes.h>
#include <Event.h>
#include <CritSection.h>
#include <Logger/Logger.h>

namespace NS_DM_Client
{
    class ProfileComponentsHolder;

    namespace NS_NotificationListener
    {
        class SessionInfo;

        class MessageHandler : public IDataSink, public NS_Common::IRunner
        {
        public:
            typedef buffer_t    message_t;

            enum Signals
            {
                e_NewMsg = NS_Common::EventEx::e_UserSignal,

                e_Stop = NS_Common::EventEx::e_Stop
            };

            MessageHandler(ProfileComponentsHolder& pch, bool checkNotificationDiggest, 
				bool plainBootstrap, bool cipherHeaderPresent, NS_Logging::Logger& logger);
            virtual ~MessageHandler();

            virtual void    Write(const void* buf, size_t size);

            virtual void    Start();
            virtual void    Stop();

        protected:
            void    add(message_t& msg);
            bool    get(message_t& msg);

            bool    checkNotificationMessage(const char* buf, size_t size, SessionInfo& sessInfo) const;
            bool    checkBootstrapMessage(const char* buf, size_t size, buffer_t& bsdata) const;

        private:
            MessageHandler(MessageHandler&);
            MessageHandler& operator = (MessageHandler&);

            std::vector<message_t>  m_messages;
            NS_Common::CritSection  m_csMsgHandler;
            NS_Common::EventEx         m_newMsg;

            ProfileComponentsHolder& m_pch;

            NS_Logging::Logger&     m_logger;

			bool m_checkNotificationDiggest;
			bool m_plainBootstrap;
			bool m_cipherHeaderPresent;

        };
    }
}
