/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

namespace NS_DM_Client
{
    namespace NS_WSP
    {
        /// PDU Types
        enum EnumPDUTypes
        {
            e_Reserved          = 0,

            e_Connect,
            e_ConnectReply,
            e_Redirect,
            e_Reply,
            e_Disconnect,
            e_Push,
            e_ConfirmedPush,
            e_Suspend,
            e_Resume,

            e_Get               = 0x40,
            e_GetOptions,
            e_GetHead,
            e_GetDelete,
            e_GetTrace,

            e_Post              = 0x60,
            e_PostPut,

            e_DataFragmentPDU   = 0x80

        };


        enum EnumContentTypes
        {
            e_Undefined     = -1,

            /// Well-Known Content Types

            // application/vnd.syncml.dm+wbxml
            e_application_vnd_syncml_dm_wbxml   = 0x42,

            // application/vnd.syncml.dm+xml
            e_application_vnd_syncml_dm_xml     = 0x43,

            // application/vnd.syncml.notification
            e_application_vnd_syncml_notification     = 0x44,

            e_CT_NotWellKnown  = 0x80,

            ///  application/vnd.wmf.bootstrap - The purpose of this Content Type number
            /// is to be use in with in WiMAX Forum Over-the-Air Provision bootstrap specification.
            e_application_vnd_wmf_bootstrap     = 0x0318

        };



        /// Well-Known Parameters
        enum EnumParameters
        {
            e_SEC       = 0x11,
            e_MAC       = 0x12
        };

    }

}


