/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include <map>
#include "commontypes.h"

#define MIME_OMA_DD "application/vnd.oma.dd+xml"

namespace NS_DM_Client
{
	namespace NS_Common
	{
		/*
		 * Abstract class that is capable of downloading file from the remote host by the specified URL.
		 */
		class Downloader
		{
		public:
			typedef enum {
				DS_FINISHED = 0,
				DS_NOT_INITIALIZED,
				DS_MALFORMED_URL,
				DS_FAILED,
				DS_NO_FREE_DISK_SPACE
			} DownloadStatus;

		public:
			Downloader();
			Downloader(const char *URL);
			virtual ~Downloader();

			// Set secondary downloader to handle data
			void SetDownloader(Downloader *pd) { m_pDownloader = pd; };

			// Start download
			// Returned value indicates download status
			virtual DownloadStatus Download() = 0;

			// Return implementation specific error code
			int GetLastError() { return m_error; };

		protected:
			typedef std::map<std::string, std::string> Properties;

			int          m_error;
			char       * m_url;
			Downloader * m_pDownloader;
			Properties   m_properties;

			/** set property read from the http header */
			virtual void setProperty(const char *, const char *);
			
			/** store received data. Return number of written bytes */
			virtual int  storeBuffer(void *buffer, uint size);
		};


		class DownloaderFactory
		{
		public:
			/**
			 * Create downloader instance.
			 * Returned object should be freed by the caller.
			 */
			static Downloader * CreateDownloader(const char *URL);

		private:
			DownloaderFactory();
			DownloaderFactory(const DownloaderFactory&);
		};
	}
}


