/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

namespace NS_DM_Client
{
	namespace NS_Communication
	{

		/// enum FUMOState defines status values of the fw update operation,
		/// that should be stored info the FUMO/State mo node.
		typedef enum {
			FS_NO_PENDING_OPERATIONS       = 10,
			FS_DOWNLOAD_FAILED             = 20,
			FS_DOWNLOAD_PROGRESSING        = 30,
			FS_DOWNLOAD_COMPLETE           = 40,
			FS_READY_TO_UPDATE             = 50,
			FS_UPDATE_PROGRESSING          = 60,
			FS_UPDATE_FAILED_HAVE_DATA     = 70,
			FS_UPDATE_FAILED_NO_DATA       = 80,
			FS_UPDATE_SUCCESSFUL_HAVE_DATA = 90,
			FS_UPDATE_SUCCESSFUL_NO_DATA   = 100
		} FUMOState;

		/// enum FWCmdStatus defines status values that should be send to the server
		/// notifying the status of the Exec command on the FUMO node.
		typedef enum {
			FW_SUCCESSFUL                  = 200,
			FW_USER_CANCELLED              = 401,
			FW_CORRUPTED_PACKAGE           = 402,
			FW_UNDEFINED_ERROR             = 409,
			FW_UPDATE_FAILED               = 410,
			FW_MALFORMED_URL               = 411,
			FW_ALT_DOWNLOAD_SERVER_ERROR   = 500

		} FWCmdStatus;

		typedef enum {
			FWO_UNDEFINED,
			FWO_DOWNLOAD,
			FWO_DOWNLOAD_AND_UPDATE,
			FWO_UPDATE
		} FWOperation;

	}
}