/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include "commontypes.h"
#include "downloader.h"
#include "Event.h"
#include "PortableThread.h"
#include "DaemonDM/Messenger.h"
#include "DeviceAdapter/IDeviceAdapter.h"
#include "treemanager/ActionCommand.h"
#include "serverexchange/firmware/DDProcessor.h"
#include "serverexchange/firmware/FUMODefines.h"

namespace NS_DM_Client
{
    namespace NS_Communication
    {
    	/**
    	 * FirmwareManager handles downloading and updating FW
    	 * Class supports receiving firmware DD file (mime "application/vnd.oma.dd+xml") from server.
    	 */
        class FirmwareManager : public Thread, private NS_Common::Downloader
        {
		public:
			FirmwareManager(ProfileComponentsHolder* prholder);
			virtual ~FirmwareManager();

			virtual Downloader::DownloadStatus Download();
			Downloader::DownloadStatus DownloadAndUpdate(bool update = false);

			void PerformDownload();
			void PerformDownloadAndUpdate();
			void PerformUpdate();

			void SetExecCmd(ExecPtr cmd);
			void SetFUMOURI(const char *uri);
			void SetFWDataURI(const char *uri);
			void SetFWURL(const char *url);
			void SetMessageID(const char *msgid);
			void SetResponseType(const char * resptype);
			void SetServerID(const char * serverID);
			
		protected:
			
			virtual int storeBuffer(void *buffer, uint size);
			virtual void run();
			
		private:
			
			bool  m_cancelled;
			bool  m_storageInitialized;
			char *m_fumouri;
			char *m_fwDataURI;
			char *m_fwFileName;
			char *m_responseType;
			char *m_serverID;
			char *m_url;
			
			FWCmdStatus               m_fwCommandStatus;
			NS_DM_Client::IDeviceAdapter::EnumFirmwareStatus m_fwStatus;
			FWOperation               m_operation;
			DDProcessor             * m_pDDProcessor;
			NS_DM_Client::Messenger * m_pMessenger;
			ProfileComponentsHolder * m_pPCH;
			ExecPtr                   m_ExecCommand;
			NS_Common::Event          m_event;

			FUMOState doUpdate();
			
			bool notifyProgress();
			
			// request sending status of the fw update
			void sendResultAlert();
			
			// write status of fu operation into the motree
			void setFUMOStatus(int value);
			FUMOState writeFWData();
        };
    }
}
