/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#pragma once

#include "Errors.h"
#include "serverexchange/commands/AlertCodes.h"
#include "serverexchange/wrappers/SAlertCommand.h"
#include "serverexchange/wrappers/SCommandAdapter.h"
#include "serverexchange/wrappers/SResultsCommand.h"
#include "serverexchange/wrappers/SStatusCommand.h"

namespace NS_DM_Client
{
	namespace NS_SyncMLCommand
	{
		/// Class SCommandFactory provides general interface to create parts of
		/// SyncML message. SCommandFactory creates wrappers for commands Add, Get, Replace, Delete
		/// and for Status and Results as well.
		class SCommandFactory
		{
		public:

			/// Create Alert
			///		<Alert>
			///			<Data>@alertCode</Data>
			///		</Alert>
			static SAlertCommandPtr CreateAlert(const AlertCode alertCode);

			/// Create Alert
			///		<Alert>
			///			<Data>@alertCode</Data>
			///			<Item>
			///				<Source>@itemsource</Source>
			///				<Data>@itemdata</Data>
			///			</Item>
			///		</Alert>
			static SAlertCommandPtr CreateAlert(const AlertCode alertCode, const char * itemsource, const char *itemdata);

			static SAlertCommandPtr CreateAlertOnFWDownload(int result, ExecPtr &exec, const char *alertType);

			/// Create generic alert command
			/// @param uri value inserted into the Source section
			/// @param reqtype value inserted into Meta::Type section
			/// @param data value inserted into data section
			static SAlertCommandPtr CreateGenericAlert(const char *srcuri, const char *reqtype, int data);


			/// Create Alert
			///		<Alert>
			///			<Data>@alertCode</Data>
			///			<Item>
			///				<Meta>
			///					<Type>@reqtype</Type>
			///				</Meta>
			///				<Source>@itemsource</Source>
			///				<Data>@data</Data>
			///			</Item>
			///		</Alert>
			static SAlertCommandPtr CreateAlert(const AlertCode alertCode, const char *srcuri, const char *reqtype, int data);

			/// Create Replace section of message
			/// DevInf reference is used to fill data of Replace command.
			static SCommandPtr CreateReplaceDevInf(Funambol::DevInf &devInf);
			static SCommandPtr CreatePutDevInf(Funambol::DevInf &devInf);

			/// Create Status section of reply.
			/// @param data status code
			static SStatusCommandPtr CreateStatus(StatusCode data);
			static SStatusCommandPtr CreateStatus(StatusCode data, AbstractCommandPtr &ptrCommand);
			static SStatusCommandPtr CreateStatus(StatusCode data, Funambol::AbstractCommand &cmd);

			/// Create Results section of message.
			/// @param cmd command that was processed
			/// @param results array of Funambol::Item* which contains data processing results
			/// @param msgref id of server message which contains requested command
			static SResultsCommandPtr CreateResult(Funambol::ItemizedCommand &cmd, Funambol::ArrayList &results, const char *msgref);
			static SResultsCommandPtr CreateResult(ItemizedCommandPtr &ptrCommand, Funambol::ArrayList &results, const char *msgref);

		private:
			SCommandFactory();
			~SCommandFactory();
		};
	}
}
