/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#pragma once

#include "ClientAdapter/INotificationUpdater.h"
#include "common/Event.h"

namespace NS_DM_Client
{
	class NotificationUpdaterImpl: public INotificationUpdater
	{
	public:
		NotificationUpdaterImpl(void* context, size_t stop = 1): INotificationUpdater(context), m_sessionStarted(false),
			m_notifyDMSession(false), m_firmwareUpdated(false), 
			m_event(reinterpret_cast<NS_Common::EventEx*>(context)), m_stopAfterN(stop)
		{} 
		virtual ~NotificationUpdaterImpl() {};

		virtual void StartDMSessionStatus(bool sessionStarted)
		{
			m_sessionStarted = sessionStarted;
			std::cout << "Received notification for StartDMSessionStatus. sessionStarted = " << m_sessionStarted << std::endl;
			if (--m_stopAfterN == 0)
			{
				m_event->signal();
			}
		}

		virtual void DMSessionNotif(NotificationStatus status)
		{
			m_notifyDMSession = true;
			std::cout << "Received notification for DMSessionNotif. sessionStarted = " << m_notifyDMSession << std::endl;
			if (--m_stopAfterN == 0)
			{
				m_event->signal();
			}
		}

		virtual void CheckFirmwareUpdateStatus(bool firmwareUpdated)
		{
			m_firmwareUpdated = firmwareUpdated;
			std::cout << "Received notification for CheckFirmwareUpdateStatus. firmwareUpdated = " << m_firmwareUpdated << std::endl;
			if (--m_stopAfterN == 0)
			{
				m_event->signal();
			}
		}

		virtual void FirmwareUpdateNotif(EnumFirmwareOperation fwo, NotificationStatus status)
		{
			std::cout << "Received notification for FirmwareUpdateNotify. Operation = " << fwo << " status  = " << status << std::endl;
			m_event->signal();
		}

		void ProvisioningUpdateNotif(const char* URI)
		{

		}

		void StartDRMDCollecting(int duration)
		{

		}


	public:
		bool m_sessionStarted;
		bool m_notifyDMSession;
		bool m_firmwareUpdated;

		NS_Common::EventEx* m_event;

		int m_stopAfterN;
	};
}
