/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */


#include "Message.h"

namespace NS_DM_Client
{
	const char* S_msgTypeDescription[] = 
	{
		"Open",
		"Close",
		"Get",
		"Set",
		"ClientProfilies",
		"StartDMSession",
		"NotifyDMSession",
		"CheckFirmwareUpdate",
		"NotifyFirmwareUpdate",
		"NotifyProvisioningUpdate",
		"Status",
		"CollectDRMD",
		"DRMDReady",
		"NetworkEntry"
	};

	const char* S_msgSubTypeDescription[] =
	{
		"DevInfo",
		"DevDetail",
		"DMAcc",
		"WiMAX",
		"WiMAXSupp",
		"WiMAX_Diagnostics",
		"ClientProfilieName",
		"EMSK",
		"DeviceID",
		"None",
		"OK",
		"Failed",
		"StopWaiting",

		"FirmwareDownload"
		"FirmwareUpdate",
		"FirmwareDownloadAndUpdate"
	};

	Message::Message(size_t id, size_t msgType, size_t msgSubType, const String& data/* = ""*/):
		m_id(id), m_type(msgType), m_subType(msgSubType)
	{
		StringToBytes(data, m_data);
	}
	//-------------------------------------------------------------------------------------------

	Message::Message(size_t id, size_t msgType, size_t msgSubType, const std::vector<byte>& data):
		m_id(id), m_type(msgType), m_subType(msgSubType), m_data(data)
	{
	}
	//-------------------------------------------------------------------------------------------

	size_t Message::GetHeaderSize()
	{
		return sizeof(size_t)/*id*/ + sizeof(size_t)/*type*/ + sizeof(size_t)/*subtype*/ + 
			sizeof(size_t)/*dataSize*/;
	}
	//-------------------------------------------------------------------------------------------

	size_t Message::GetDataSize()
	{
		return sizeof(size_t);
	}
	//-------------------------------------------------------------------------------------------

	void Message::SetData(void* buffer, size_t size)
	{
		if (size == 0)
		{
			m_data.clear();
			return;
		}
		m_data.resize(size);
		memset(&m_data[0], 0, size);
		memcpy(&m_data[0], buffer, size);
	}
	//-------------------------------------------------------------------------------------------

	void BytesToString(const std::vector<byte>& bytes, String& str)
	{
		if (bytes.size() == 0)
			return;
		int size = bytes.size() + /*last 0*/sizeof(char);
		char* tempResult = new char[size];
		memset(tempResult, 0, size);
		memcpy(tempResult, &bytes[0], bytes.size());
		str = tempResult;
		delete [] tempResult;
	}
	//-------------------------------------------------------------------------------------------

	void StringToBytes(const String& str, std::vector<byte>& bytes)
	{
		size_t size = str.size(); 
		if (size == 0)
			return;
		bytes.resize(size);
		memcpy(&bytes[0], str.c_str(), size);
	}
}