/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "IPCDaemonEngineActionThread.h"
#include "DaemonDM/IPCDaemonEngine.h"
#include "daemon/IDaemonEngine.h"
#include "common/Buffer.h"
#include "MessengerDefs.h"
#include "Logger/Logger.h"

namespace NS_DM_Client
{

//------------------------------------------------------------------------------------------------------
IPCDaemonEngineActionThread::IPCDaemonEngineActionThread()
{

}
//------------------------------------------------------------------------------------------------------
IPCDaemonEngineActionThread::~IPCDaemonEngineActionThread()
{

}
//------------------------------------------------------------------------------------------------------
bool IPCDaemonEngineActionThread::Init(IPCDaemonEngine* engine)
{
    m_engine = engine;
    return true;
}
//------------------------------------------------------------------------------------------------------
bool IPCDaemonCheckStopCondition(const Buffer& buffer)
{
    char stop_request[/*c_StopRequestSize*/4 + 1];
    stop_request[c_StopRequestSize] = '\0';
    memcpy(stop_request, buffer.GetPointer(), c_StopRequestSize);
    if (strcmp(stop_request, c_StopRequest) == 0)
    {
        return true;
    }
    return false;
}
//------------------------------------------------------------------------------------------------------
void IPCDaemonEngineActionThread::run()
{
    IFIFOWrapper* fifo_request, *fifo_response;
    while (true)
    {
        if (!initializeIPCFifos(fifo_request, fifo_response, false, true))
        {
            return;
        }
        while (true)
        {
            UIExchangeHead request_head;
            Buffer buffer(sizeof(UIExchangeHead));
            if (fifo_request->Read(buffer) == e_Ok)
            {
                if (IPCDaemonCheckStopCondition(buffer))
                {   // stop thread
                    releaseFifos(fifo_request, fifo_response);
                    return;
                }
                memcpy(&request_head, buffer.GetPointer(), sizeof(UIExchangeHead));
                buffer.Allocate(request_head.m_payload_size);
                if (fifo_request->Read(buffer) == e_Ok)
                {
                    Buffer response_payload;
                    UIResponseExchangeHead response_head;
                    StatusCode request_status =
                        m_engine->GetDaemonEngine()->HandleClientRequest(request_head.m_type, buffer, response_head.m_perform_code, response_payload);
                    if (request_status != e_Ok)
                    {
                        response_head.m_perform_code = e_Failed;
                        response_head.m_payload_size = 0;
                    }
                    else
                    {
                        response_head.m_payload_size = response_payload.Size();
                    }

                    buffer.Allocate(sizeof(response_head) + response_head.m_payload_size);
                    memcpy(buffer.GetPointer(), &response_head, sizeof(response_head));
                    if (response_head.m_payload_size > 0)
                    {
                        memcpy(((char*)buffer.GetPointer()) + sizeof(response_head), response_payload.GetPointer(), response_payload.Size());
                    }
                    fifo_response->Write(buffer);
                }
            }
            else
            {
                releaseFifos(fifo_request, fifo_response);
                break;
            }
        }
    }
    return;
}

}
