/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#include "DaemonDM/Messenger.h"

#include "iostream"

using namespace std;

using namespace NS_DM_Client;

enum notify_type
{
    e_exit = 0,
    e_bad_input,
    e_display,
    e_confirmation,
    e_userInput,
    e_userChoice,
    e_progressNotification
};

notify_type UserInputChoise(char* input)
{
    if (input && (strlen(input) > 0))
    {
        if ((input[0] == 'q') || (input[0] == 'Q'))
        {
            return e_exit;
        }

        if ((input[0] == 'd') || (input[0] == 'D'))
        {
            return e_display;
        }

        if ((input[0] == 'c') || (input[0] == 'C'))
        {
            return e_confirmation;
        }

        if ((input[0] == 'i') || (input[0] == 'I'))
        {
            return e_userInput;
        }

        if ((input[0] == 'h') || (input[0] == 'H'))
        {
            return e_userChoice;
        }

        if ((input[0] == 'p') || (input[0] == 'P'))
        {
            return e_progressNotification;
        }
    }

    return e_bad_input;
}

const char* c_choises_delimiter = "-";

void formUserAvialableChoiseSetFromString(const String& av_choise_str, UserAvialableChoiseSet& av_choise)
{
    size_t pos_beg = 0;
    size_t pos_end = 0;
    String choises_with_end_separator = av_choise_str + c_choises_delimiter;
    String choise;
    av_choise.clear();
    while ((pos_end = choises_with_end_separator.find(c_choises_delimiter, pos_beg)) != String::npos )
    {
        choise = choises_with_end_separator.substr(pos_beg, pos_end - pos_beg);
        av_choise.push_back(choise);
        pos_beg = pos_end + strlen(c_choises_delimiter);
    }
}

int main()
{
    Messenger* messenger = CreateMessenger();
    if (messenger)
    {
        char usr_input[256];

        while (true)
        {
            bool exit_cucle = false;
            cout<< "input what to do:" << endl;
            char* ress = fgets(usr_input, 255, stdin);
            if (!ress)
            {
                // some error
            }
            usr_input[strlen(usr_input)-1] = '\0';

            usr_input[0] = 'p';
            usr_input[1] = '\0';

            notify_type type = UserInputChoise(usr_input);
            switch (type)
            {
            case e_exit:
            {
                exit_cucle = true;
                cout<< "Exit from MessengerTest" << endl;
                break;
            }
            case e_bad_input:
            {
                //cout<< "user put bad command. Please try again" << endl;
                break;
            }
            case e_display:
            {
                UIOptionalParameters pars;
                pars.push_back(UIOptionalParameterData(e_MAXDT, "100"));
                if (messenger->Display("this is test display", pars) == e_Ok)
                {
                    cout<< "Display success" << endl;
                }
                else
                {
                    cout<< "Display failed" << endl;
                }

                break;
            }
            case e_confirmation:
            {
                UIOptionalParameters pars;
                pars.push_back(UIOptionalParameterData(e_MAXDT, "100"));
                if (messenger->Confirmation("this is test user input", pars) == e_Ok)
                {
                    cout<< "Confirmation success. Result: Yes" << endl;
                }
                else
                {
                    cout<< "Confirmation success. Result: No (Cancelled)" << endl;
                }

                break;
            }
            case e_userInput:
            {
                UIOptionalParameters pars;
                pars.push_back(UIOptionalParameterData(e_MAXDT, "100"));
                pars.push_back(UIOptionalParameterData(e_DR, "no input from user"));
                String input;
                if (messenger->UserInput("this is test user input", pars, input) == e_Ok)
                {
                    cout<< "UserInput success. Input: " << input << endl;
                }
                else
                {
                    cout<< "UserInput failed" << endl;
                }

                break;
            }
            case e_userChoice:
            {
                UserAvialableChoiseSet avialable_choises;

                char av_choise[1024];
                cout<< "Input avialable choise set separated by \'-\':" << endl;
                char* ress = fgets(av_choise, 1023, stdin);
                if (!ress)
                {
                    // some error
                }
                av_choise[strlen(av_choise)-1] = '\0';

                char av_many_choises;
                cout << "Allow multiple choise set ?. Input \'y\' if allow or any other char if not allow:" << endl;
                cin >> av_many_choises;

                bool allowMultiplechoises = (av_many_choises == 'y') ? true : false;

                formUserAvialableChoiseSetFromString(av_choise, avialable_choises);
                UserChoiseSet user_choises;

                UIOptionalParameters pars;
                pars.push_back(UIOptionalParameterData(e_MAXDT, "110"));
                pars.push_back(UIOptionalParameterData(e_DR, "1"));

                if (messenger->UserChoice("this is test user choises", pars, avialable_choises, user_choises, allowMultiplechoises) == e_Ok)
                {
                    String choises = "";
                    for (size_t i = 0; i != user_choises.size(); ++i)
                    {
                        if ((user_choises[i] < 0) || (user_choises[i] >= (int)avialable_choises.size()))
                        {
                            cout<< "user choises: messenger failed." << endl;
                            break;
                        }
                        choises = choises + (String)" " + avialable_choises[user_choises[i]];
                    }
                    cout<< "UserChoice success. Choise: " << choises << endl;
                }
                else
                {
                    cout<< "UserChoice failed" << endl;
                }

                break;
            }
            case e_progressNotification:
            {
                UIOptionalParameters pars;
                pars.push_back(UIOptionalParameterData(e_MAXDT, "100"));

                long progress = 85;

                if (messenger->ProgressNotification("this is test progress notification", pars, progress) == e_Ok)
                {
                    cout<< "Display success" << endl;
                }
                else
                {
                    cout<< "Display failed" << endl;
                }

                break;
            }
            };

            if (exit_cucle)
            {
                break;
            }
        }





        messenger->Release();
    }

    return 0;
}
