/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "CDataStorage.h"
#include "DataStorageDefs.h"

#include <sys/stat.h>
#include <sys/types.h>

#include <string.h>

#include "Logger/Logger.h"

#include "common/Buffer.h"

namespace NS_DM_Client
{
namespace NS_DataStorage
{

//------------------------------------------------------------------------------------------------------
CStreamHandler::CStreamHandler(FILE* file, String name)
    : m_file(file), m_name(name), m_isFinishWriting(false)
{
}
//------------------------------------------------------------------------------------------------------
CStreamHandler::~CStreamHandler()
{
    if (m_file)
    {
        //SYNC_STREAM_HANDLER_LOCK

        fclose(m_file);

        //SYNC_UNLOCK

        // unlink(m_name.c_str());
    }
}
//------------------------------------------------------------------------------------------------------
bool CStreamHandler::Write(const void* buffer, size_t size)
{
    bool res = m_file && buffer && (size > 0) && (!m_isFinishWriting);
    if (res)
    {
        //SYNC_STREAM_HANDLER_LOCK

        res = (fwrite(buffer, 1, size, m_file) == size);

        //SYNC_UNLOCK
    }
    return res;
}
//------------------------------------------------------------------------------------------------------
bool CStreamHandler::Write(const Buffer& buffer)
{
    return Write(buffer.GetPointer(), buffer.Size());
}
//------------------------------------------------------------------------------------------------------
bool CStreamHandler::FinishWriting()
{
    bool res = m_file && (!m_isFinishWriting);
    if (res)
    {
        //SYNC_STREAM_HANDLER_LOCK

        if (fclose(m_file) == 0)
        {
            res = m_isFinishWriting = ((m_file = fopen(m_name.c_str(), "rb")) != 0);
        }
        else
        {
            // error logging
        }

       // SYNC_UNLOCK
    }
    return res;
}
//------------------------------------------------------------------------------------------------------
void CStreamHandler::Release()
{
    delete this;
}

}

}
