/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#define BOOST_TEST_MAIN

#include <boost/test/unit_test.hpp>
#include "boost/filesystem/operations.hpp"
#include "boost/filesystem/path.hpp"

#include <iostream>
#include "../BeceemAdapter.h"
#include "../ManagementObjects/DevInfo.h"
#include "../ManagementObjects/DevDetail.h"
#include "../ManagementObjects/DMAcc.h"
#include "../ManagementObjects/WiMAX.h"
#include "../ManagementObjects/WiMAXSupp.h"


NS_DM_Client::IDeviceAdapter* S_beceemAdapter = 0;

namespace fs = boost::filesystem;

class DataStorageConfig
{
public:
	DataStorageConfig()
	{
		S_beceemAdapter = (NS_DM_Client::BeceemAdapter*)CreateDeviceAdapter(0);
		std::cout << "Setup" << std::endl;
	}

	~DataStorageConfig()
	{
 		delete S_beceemAdapter;
		std::cout << "Tear down" << std::endl;
	}
};

BOOST_GLOBAL_FIXTURE(DataStorageConfig);

//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(OpenDevice)
{
	BOOST_CHECK(S_beceemAdapter->Open());
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(CloseDevice)
{
	BOOST_CHECK(S_beceemAdapter->Close());
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(GetDeviceInfo)
{
	S_beceemAdapter->Open();
	NS_DM_Client::DevInfo deviceInfo;
	BOOST_CHECK(S_beceemAdapter->GetDeviceInfo(deviceInfo));
	BOOST_CHECK(!deviceInfo.m_DevId.empty());
	BOOST_CHECK(!deviceInfo.m_Man.empty());
	BOOST_CHECK(!deviceInfo.m_Mod.empty());
	BOOST_CHECK(!deviceInfo.m_DmV.empty());
	BOOST_CHECK(!deviceInfo.m_Lang.empty());
	S_beceemAdapter->Close();
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(GetDeviceDetail)
{
	S_beceemAdapter->Open();
	NS_DM_Client::DevDetail deviceDetail;
	BOOST_CHECK(S_beceemAdapter->GetDeviceDetail(deviceDetail));
	BOOST_CHECK(!deviceDetail.m_DevTyp.empty());
	BOOST_CHECK(!deviceDetail.m_OEM.empty());
	BOOST_CHECK(!deviceDetail.m_FwV.empty());
	BOOST_CHECK(!deviceDetail.m_SwV.empty());
	BOOST_CHECK(!deviceDetail.m_HwV.empty());
	S_beceemAdapter->Close();
}
//-------------------------------------------------------------------------------------------


BOOST_AUTO_TEST_CASE(GetDMAccount)
{
	S_beceemAdapter->Open();
	NS_DM_Client::DMAcc DMAcc;
	BOOST_CHECK(S_beceemAdapter->GetDMAccount(DMAcc));
	BOOST_CHECK(!DMAcc.m_DMAccImpl[0].m_AAuthPref.empty());
	BOOST_CHECK(!DMAcc.m_DMAccImpl[0].m_AppID.empty());
	BOOST_CHECK(!DMAcc.m_DMAccImpl[0].m_Name.empty());
	BOOST_CHECK(!DMAcc.m_DMAccImpl[0].m_PrefConRef.empty());
	BOOST_CHECK(!DMAcc.m_DMAccImpl[0].m_ServerID.empty());
	BOOST_CHECK(DMAcc.m_DMAccImpl[0].m_AppAddr.size() != 0);
	BOOST_CHECK(DMAcc.m_DMAccImpl[0].m_AppAuth.size() != 0);
	BOOST_CHECK(DMAcc.m_DMAccImpl[0].m_ToConRef.size() != 0);
	S_beceemAdapter->Close();
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(GetWiMax)
{
	S_beceemAdapter->Open();
	NS_DM_Client::WiMAX wimax;
	BOOST_CHECK(S_beceemAdapter->GetWiMAX(wimax));
	BOOST_CHECK(!wimax.m_TO_WiMAX_REF.empty());
	BOOST_CHECK(wimax.m_WiMAXRadioModule.size() != 0);
	BOOST_CHECK(!wimax.m_WiMAXRadioModule[0].m_FwV.empty());
//	BOOST_CHECK(!wimax.m_WiMAXRadioModule[0].m_HwV.empty()); it is empty in Beceem
//	BOOST_CHECK(!wimax.m_WiMAXRadioModule[0].m_MACAddress.empty());
	BOOST_CHECK(!wimax.m_WiMAXRadioModule[0].m_Man.empty());
	BOOST_CHECK(!wimax.m_WiMAXRadioModule[0].m_Mod.empty());
//	BOOST_CHECK(!wimax.m_TerminalEquipment.m_DevID.empty());
	S_beceemAdapter->Close();
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(GetWiMaxSupp)
{
	S_beceemAdapter->Open();
	NS_DM_Client::WiMAXSupp wimaxSupp;
	BOOST_CHECK(S_beceemAdapter->GetWiMAXSupp(wimaxSupp));
	BOOST_CHECK(wimaxSupp.m_Operator.size() != 0);
	BOOST_CHECK(wimaxSupp.m_Operator[0].m_SubscriptionParameters.m_Primary.m_EAP.size() != 0);
	BOOST_CHECK(wimaxSupp.m_Operator[0].m_SubscriptionParameters.m_Primary.m_EAP[0].m_CERT.size() != 0);
	BOOST_CHECK(!wimaxSupp.m_Operator[0].m_SubscriptionParameters.m_Primary.m_EAP[0].m_CERT[0].m_CERT_TYPE.empty());

	S_beceemAdapter->Close();
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SetDeviceInfo)
{
	S_beceemAdapter->Open();
	NS_DM_Client::DevInfo originalDevInfo;
	S_beceemAdapter->GetDeviceInfo(originalDevInfo); // backup

	NS_DM_Client::DevInfo newDevInfo(originalDevInfo);
	std::string deviceId("111");
	newDevInfo.m_DevId = deviceId;
	// rest fields are the same
	BOOST_CHECK(S_beceemAdapter->SetDeviceInfo(newDevInfo));
	NS_DM_Client::DevInfo realDevInfo;
	S_beceemAdapter->GetDeviceInfo(realDevInfo);
	BOOST_CHECK(deviceId == realDevInfo.m_DevId);

	// rollback last set
	BOOST_CHECK(S_beceemAdapter->SetDeviceInfo(originalDevInfo));

	S_beceemAdapter->Close();
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SetDeviceDetail)
{
	S_beceemAdapter->Open();
	NS_DM_Client::DevDetail originalDevDetail;
	S_beceemAdapter->GetDeviceDetail(originalDevDetail); // backup

	NS_DM_Client::DevDetail newDevDetail(originalDevDetail);
	std::string deviceType("111");
	newDevDetail.m_DevTyp = deviceType;
	// rest fields are the same
	BOOST_CHECK(S_beceemAdapter->SetDeviceDetail(newDevDetail));
	NS_DM_Client::DevDetail realDevDetail;
	S_beceemAdapter->GetDeviceDetail(realDevDetail);
	BOOST_CHECK(deviceType == realDevDetail.m_DevTyp);

	// rollback last set
	BOOST_CHECK(S_beceemAdapter->SetDeviceDetail(originalDevDetail));

	S_beceemAdapter->Close();
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SetDMAcc)
{
	S_beceemAdapter->Open();
	NS_DM_Client::DMAcc originalDMAcc;
	S_beceemAdapter->GetDMAccount(originalDMAcc); // backup

	NS_DM_Client::DMAcc newDMAcc(originalDMAcc);
	NS_DM_Client::DMAccImpl newDMAccImpl;
	std::string name("111");
	newDMAccImpl.m_Name = name;
	newDMAcc.m_DMAccImpl.push_back(newDMAccImpl);
	// rest fields are the same
	BOOST_CHECK(S_beceemAdapter->SetDMAccount(newDMAcc));
	NS_DM_Client::DMAcc realDMAcc;
	S_beceemAdapter->GetDMAccount(realDMAcc);
	BOOST_CHECK(name == realDMAcc.m_DMAccImpl[0].m_Name);

	// rollback last set
	BOOST_CHECK(S_beceemAdapter->SetDMAccount(originalDMAcc));

	S_beceemAdapter->Close();
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SetWiMax)
{
	S_beceemAdapter->Open();
	NS_DM_Client::WiMAX originalWiMax;
	S_beceemAdapter->GetWiMAX(originalWiMax); // backup

	NS_DM_Client::WiMAX newWiMax(originalWiMax);
	std::string man("111");
	newWiMax.m_WiMAXRadioModule[0].m_Man = man;
	// rest fields are the same
	BOOST_CHECK(S_beceemAdapter->SetWiMAX(newWiMax));
	NS_DM_Client::WiMAX realWiMax;
	S_beceemAdapter->GetWiMAX(realWiMax);
	BOOST_CHECK(man == realWiMax.m_WiMAXRadioModule[0].m_Man);

	// rollback last set
	BOOST_CHECK(S_beceemAdapter->SetWiMAX(originalWiMax));
	S_beceemAdapter->Close();
}
//-------------------------------------------------------------------------------------------

BOOST_AUTO_TEST_CASE(SetWiMaxSupp)
{
	S_beceemAdapter->Open();
	NS_DM_Client::WiMAXSupp originalWiMaxSupp;
	S_beceemAdapter->GetWiMAXSupp(originalWiMaxSupp); // backup

	NS_DM_Client::WiMAXSupp newWiMaxSupp(originalWiMaxSupp);
	std::string toIpRef("111");
	newWiMaxSupp.m_Operator[0].m_TO_IP_REF = toIpRef;
	// rest fields are the same
	BOOST_CHECK(S_beceemAdapter->SetWiMAXSupp(newWiMaxSupp));
	NS_DM_Client::WiMAXSupp realWiMaxSupp;
	S_beceemAdapter->GetWiMAXSupp(realWiMaxSupp);
	BOOST_CHECK(toIpRef == realWiMaxSupp.m_Operator[0].m_TO_IP_REF);

	// rollback last set
	BOOST_CHECK(S_beceemAdapter->SetWiMAXSupp(originalWiMaxSupp));
	S_beceemAdapter->Close();
}
//-------------------------------------------------------------------------------------------
