/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "TranslateDiagnosticsStructures.h"

namespace NS_DM_Client
{
namespace NS_DM_Diagnostics
{

bool TranslateStart(ST_Diag_Start_P in, Start& out)
{
    bool res = false;
    if (in)
    {
        out.m_Duration = (int)in->Duration;
        out.m_Server_ID = (char*)(in->Server_ID);
        out.m_Origination_ID = (char*)(in->Origination_ID);
        res = true;
    }
    return res;
}

bool TranslateWiMAX(ST_Diag_WiMAX_P in, WiMAX& out)
{
    bool res = false;
    if (in)
    {
        out.m_ServBSID = (int)in->ServBSID;
        out.m_DownlinkFreq = (int)in->DownlinkFreq;
        out.m_DownlinkBandwidth = (int)in->DownlinkBandwidth;
        out.m_DownlinkMeanRSSI = (char*)(in->DownlinkMeanRSSI);
        out.m_DownlinkStdDevRSSI = (char*)(in->DownlinkStdDevRSSI);
        out.m_DownlinkMeanCINR = (char*)(in->DownlinkMeanCINR);
        out.m_DownlinkStdDevCINR = (char*)(in->DownlinkStdDevCINR);
        out.m_TxPwr = (int)in->TxPwr;
        out.m_TxHeadroomPwr = (int)in->TxHeadroomPwr;
        out.m_ScannedBaseStations = (char*)(in->ScannedBaseStations);
        out.m_LinkUptime = (int)in->LinkUptime;
        out.m_HARQRetTX = (char*)(in->HARQRetTX);
        out.m_HARQRetRX = (char*)(in->HARQRetRX);
        out.m_InitRangeResp = (int)in->InitRangeResp;
        out.m_InitRangeNoResp = (int)in->InitRangeNoResp;
        out.m_PerRangeResp = (int)in->PerRangeResp;
        out.m_PerRangeNoResp = (int)in->PerRangeNoResp;
        out.m_HOSuccess = (int)in->HOSuccess;
        out.m_HOFail = (int)in->HOFail;
        out.m_MAPRecSuccess = (int)in->MAPRecSuccess;
        out.m_MAPRecFail = (int)in->MAPRecFail;
        out.m_MCSstatsDL = (char*)(in->MCSstatsDL);
        out.m_MCSstatsUL = (char*)(in->MCSstatsUL);
        out.m_VersionOfMCSMetric = (int)in->VersionOfMCSMetric;
        out.m_DownlinkDataRate = (char*)(in->DownlinkDataRate);
        out.m_UplinkDataRate = (char*)(in->UplinkDataRate);
        out.m_PacketsReceived = (int)in->PacketsReceived;
        out.m_PacketsSent = (int)in->PacketsSent;
        out.m_MACState = (char*)(in->MACState);
        out.m_PreambleIndex = (char*)(in->PreambleIndex);
        out.m_HOLatency = (int)in->HOLatency;
        out.m_FrameRatio = (char*)(in->FrameRatio);
        out.m_HOAttempts = (int)in->HOAttempts;
        out.m_NetworkEntryLatency = (int)in->NetworkEntryLatency;
        out.m_NetworkEntrySucceses = (int)in->NetworkEntrySucceses;
        out.m_NetworkEntryFailures = (int)in->NetworkEntryFailures;
        out.m_NetworkEntryAttempts = (int)in->NetworkEntryAttempts;
        out.m_UserAccessTime = (int)in->UserAccessTime;
        out.m_ARQ_Retries_Received = (int)in->ARQ_Retries_Received;
        out.m_ARQ_Retries_Transmitted = (int)in->ARQ_Retries_Transmitted;
        out.m_CQICH = (int)in->CQICH;
        out.m_Service_Flows = (char*)(in->Service_Flows);
        out.m_Airlink_Security = (char*)(in->Airlink_Security);
        out.m_Certificates = (char*)(in->Certificates);

        res = true;
    }

    return res;
}

//---------------------------------------------------------------------------------------------

bool TranslateGeneric(ST_Diag_Generic_P in, Generic& out)
{
    bool res = false;
    if (in)
    {
        out.m_RateLimiterStats = (int)in->RateLimiterStats;
        out.m_TimeActive = (int)in->TimeActive;
        out.m_TimeIdle = (int)in->TimeIdle;
        out.m_TimeSleep = (int)in->TimeSleep;
        out.m_LastRebootCause = (char*)(in->LastRebootCause);
        out.m_DeviceTemp = (int)in->DeviceTemp;
        out.m_SupVolt = (int)in->SupVolt;
        out.m_BatteryCap = (int)in->BatteryCap;
        out.m_GPSlocation_Latitude = (int)in->GPSlocation_Latitude;
        out.m_GPSlocation_Longitude = (int)in->GPSlocation_Longitude;
        out.m_GPSlocation_Altitude = (int)in->GPSlocation_Altitude;
        res = TranslateLANEtherMAC(&(in->lanEtherMAC[0]), out.m_LANEtherMAC);
        res &= TranslateIPPingDiagnostics(&(in->iPPingDiagnostics[0]), out.m_IPPingDiagnostics);
        out.m_DeviceUptime = (int)in->DeviceUptime;
        out.m_DeviceLog = (char*)(in->DeviceLog);
	    out.m_Primary_DNS = (char*)(in->Primary_DNS);
	    out.m_Secondary_DNS = (char*)(in->Secondary_DNS);
	    out.m_Gateway = (char*)(in->Gateway);
	    out.m_Subnet_Mask = (char*)(in->Subnet_Mask);
	    out.m_Wimax_Interface_IP_Addr = (char*)(in->Wimax_Interface_IP_Addr);
	    out.m_DHCP_Leases = (int)in->DHCP_Leases;
	    out.m_Port_Forwarding = (char*)(in->Port_Forwarding);
    }

    return res;
}

//---------------------------------------------------------------------------------------------

bool TranslateLANEtherMAC(ST_Diag_LANEtherMAC_P in, LANEtherMAC& out)
{
    bool res = false;

    if (in)
    {
        out.m_Enable = (char*)(in->Enable);
        out.m_MACAddressControlEnabled = (char*)(in->MACAddressControlEnabled);
        out.m_MaxBitrate = (char*)(in->MaxBitrate);
        out.m_DuplexMode = (char*)(in->DuplexMode);
        out.m_LANEtherMACresults = (char*)(in->LANEtherMACresults);
        res = true;
    }

    return res;
}

//---------------------------------------------------------------------------------------------

bool TranslateIPPingDiagnostics(ST_Diag_IPPingDiagnostics_P in, IPPingDiagnostics& out)
{
    bool res = false;

    if (in)
    {
        out.m_DiagnosticsState = (char*)(in->DiagnosticsState);
        out.m_Interface = (char*)(in->Interface);
        out.m_Host = (char*)(in->Host);
        out.m_NumberOfRepetition = (int)in->NumberOfRepetition;
        out.m_Timeout = (int)in->Timeout;
        out.m_DataBlockSize = (int)in->DataBlockSize;
        out.m_DSCP = (int)in->DSCP;
        out.m_IPPingDiagnosticsResults = (char*)(in->IPPingDiagnosticsResults);
        res = true;
    }

    return res;
}

//---------------------------------------------------------------------------------------------

bool TranslateExt(ST_Diag_Ext_P in, Ext& out)
{
    bool res = false;

    if (in)
    {
		out.m_Platform_Memory = (int)in->Platform_Memory;
		out.m_Processor_id = (int)in->Processor_id;
		out.m_Processor_type = (char*)(in->Processor_type);
		out.m_CPU_Utilization = (int)in->CPU_Utilization;
		out.m_RAM_Utilization = (int)in->RAM_Utilization;
		out.m_Hard_Drive_Number = (char*)(in->Hard_Drive_Number);
        res = true;
    }

    return res;
}


}
}
