/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

#include "../stdafx.h"
#include "Utils.h"
#include "FStream.h"
#include <stdio.h>
#include <stdarg.h>

#include <boost/date_time/posix_time/posix_time.hpp>
namespace pt = boost::posix_time;

//#if defined(WIN32)
//#	if !defined(snprintf)
//#		define snprintf _snprintf
//#		define vsnprintf _vsnprintf
//#	endif
//#endif

namespace NS_Logging
{
	FStream::FStream(const char* ident): m_ident(ident)
	{
	}
	//-------------------------------------------------------------------------------------------

	FStream::~FStream()
	{
		Close();
	}
	//-------------------------------------------------------------------------------------------

	void FStream::Open(const char* filename)
	{
		m_ofstream.open(filename, std::ios::app);
		if (!m_ofstream)
		{
			std::cout << "ERROR: Cannot create logfile \"" << std::string(filename) << std::endl;
			//			throw std::runtime_error((std::string("Cannot create Log file: ") + filename).c_str());
			return;
		}
		m_ofstream.rdbuf()->pubsetbuf(0, 0); // to suppress buffering
	}
	//-------------------------------------------------------------------------------------------

	void FStream::Close()
	{
		m_ofstream.close();
	}
	//-------------------------------------------------------------------------------------------

	void FStream::Write(const char* buffer, int size)
	{
		m_ofstream.write(buffer, size); // thread safe operation
	}
	//-------------------------------------------------------------------------------------------

	int FStream::FormatMessage(char* buffer, int size, int threadID, const char* category, const char* functionName)
	{
		pt::time_duration td(pt::microsec_clock::local_time().time_of_day());
		size_t millisecs = (size_t)td.fractional_seconds() / 1000;
		int written = _snprintf(buffer, size, "%02i:%02i:%02i,%03i % 5i %s %s %s: ", td.hours(), td.minutes(), td.seconds(), 
   				millisecs, threadID, m_ident.c_str(), functionName, category);
		return written;
	}
	//-------------------------------------------------------------------------------------------

	int FStream::FormatMessage(char* buffer, int size, int threadID, const char* category)
	{
		pt::time_duration td(pt::microsec_clock::local_time().time_of_day());
		size_t millisecs = (size_t)td.fractional_seconds() / 1000;
		int written = _snprintf(buffer, size, "%02i:%02i:%02i:%03i % 5i %s %s: ", td.hours(), td.minutes(), td.seconds(), 
			millisecs, threadID, m_ident.c_str(), category);
		return written;
	}

}