/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include <base/util/utils.h>
#include "downloader.h"
#include "platform.h"

//#include "common/CurlDownloader.h"
#include "CurlDownloader.h"
/*#if defined(PLATFORM_LINUX)
	#include "posix/CurlDownloader.h"
#elif defined(PLATFORM_MAC)
	#include "posix/CurlDownloader.h"
#elif defined(PLATFORM_ANDROID)
	#include "posix/CurlDownloader.h"
#elif defined(PLATFORM_WINDOWS)
	#include "windows/WinDownloader.h"
#else
	# error No Downloader class defined for your platform
#endif

	*/
#include <Logger/LoggerMacroses.h>

using namespace NS_DM_Client::NS_Common;


Downloader::Downloader() : m_error(DS_NOT_INITIALIZED), m_url(NULL), m_pDownloader(NULL)
{
	m_url  = Funambol::stringdup("");
}

Downloader::Downloader(const char *URL) : m_error(0), m_url(NULL), m_pDownloader(NULL)
{
	m_url  = Funambol::stringdup(URL);
}

Downloader::~Downloader()
{
	SAFE_DELETE_ARR(m_url);
	m_pDownloader = NULL;
}

void Downloader::setProperty(const char *pname, const char *pvalue)
{
	if (m_pDownloader)
		m_pDownloader->setProperty(pname, pvalue);
	else
		m_properties[pname] = pvalue;
}

int Downloader::storeBuffer(void *buffer, unsigned int size)
{
	if (m_pDownloader)
	{
		return m_pDownloader->storeBuffer(buffer, size);
	}
	return 0;
}

Downloader * DownloaderFactory::CreateDownloader(const char *URL)
{
	Downloader *d = NULL;
	d = new CurlDownloader(URL);
	/*
#if defined(PLATFORM_LINUX)
	d = new CurlDownloader(URL);
#elif defined(PLATFORM_MAC)
	d = new CurlDownloader(URL);
#elif defined(PLATFORM_ANDROID)
	d = new CurlDownloader(URL);
#elif defined(PLATFORM_WINDOWS)
	d = new WinDownloader(URL);
#else
	# error No Downloader class defined for your platform
#endif
	*/
	return d;
}

