/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "XMLConfigurationParser.h"
#include <base/util/XMLProcessor.h>

namespace NS_DM_Client
{

XMLConfigurationParser::XMLConfigurationParser()
    : m_isGroup(false)
{


}

//-------------------------------------------------------------------------------------------

XMLConfigurationParser::~XMLConfigurationParser()
{

}

//-------------------------------------------------------------------------------------------

void XMLConfigurationParser::Release()
{
    delete this;
}

//-------------------------------------------------------------------------------------------

bool XMLConfigurationParser::Init(const char* configuration, const char* group)
{
    m_isGroup = false;
    m_xml = configuration;
    bool res = false;

    if (group)
    {   // check group existence
        m_group = group;
        res = checkGroupExist();
    }
    else
    {
        res = true;
    }

    if (!res)
    {
        m_xml.clear();
    }

    return true;
}

//-------------------------------------------------------------------------------------------

bool XMLConfigurationParser::GetProperty(const String& name, String& value)
{
    // check Init status
    if (m_xml.empty())
    {
        return false;
    }

    return getProperty(name, value);

    return false;
}

//-------------------------------------------------------------------------------------------

bool XMLConfigurationParser::checkGroupExist()
{
    bool res = false;
    unsigned int start = 0;
    unsigned int end = 0;
    const char* ptr = Funambol::XMLProcessor::getElementContent(m_xml.c_str(), m_group.c_str(), NULL, &start, &end);
    if (ptr)
    {
        Funambol::StringBuffer buffer;
        Funambol::XMLProcessor::copyContent(m_xml.c_str(), start, end, buffer);
        if (buffer.c_str() != 0)
        {
            start = end = 0;
            if (Funambol::XMLProcessor::getElementAttributes(m_xml.c_str(), m_group.c_str(), &start, &end))
            {
                // if attributes exist than mean that group exist
                m_xml = buffer.c_str();
                m_isGroup = true;
                res = true;
            }
        }
    }

    if (!res)
    {
        m_group.clear();
    }

    return res;
}

//-------------------------------------------------------------------------------------------

bool XMLConfigurationParser::getProperty(const String& name, String& value)
{
    unsigned int start = 0;
    unsigned int end = 0;
    const char* node = Funambol::XMLProcessor::getElementContent(m_xml.c_str(), name.c_str(), 0, &start, &end);
    if (node)
    {
        Funambol::StringBuffer buffer;
        Funambol::XMLProcessor::copyContent(m_xml.c_str(), start, end, buffer);
        if (buffer.c_str())
        {
            value = buffer.c_str();
            return true;
        }
    }
    return false;
}

//-------------------------------------------------------------------------------------------

}
