/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */


#include "commontypes.h"
#include "serverexchange/commands/DRMDReadyNotificationCommand.h"
#include "serverexchange/commands/NotifySEMDRMDReadyCommand.h"
#include "daemon/INotificationCenter.h"
#include "treemanager/IMOTreeManager.h"
#include "executionqueue/IExecutionQueue.h"

#define URI_DIAGNOSTICS_START         "./WiMAX_Diagnostics/Start"
#define URI_DIAGNOSTICS_DURATION      "./WiMAX_Diagnostics/Start/Duration"
#define URI_DIAGNOSTICS_SERVERID      "./WiMAX_Diagnostics/Start/Server_ID"
#define URI_DIAGNOSTICS_ORIGINATIONID "./WiMAX_Diagnostics/Start/Origination_ID"

using namespace NS_DM_Client;

DRMDReadyNotificationCommand::DRMDReadyNotificationCommand(ProfileComponentsHolder* pch)
: m_pProfile(pch)
{
}


bool DRMDReadyNotificationCommand::Execute()
{

	String valueServerid;
	if (e_Ok == m_pProfile->GetMOTreeManager()->GetValue(URI_DIAGNOSTICS_SERVERID, valueServerid, NULL))
	{
		// check if there is an acc record for server_id //ask SEM
/*
		if (!m_pProfile->GetServerExchangeManager()->HasAccountFor(valueServerid))
		{
			GDLERROR("Received 'exec diagnostics' but no DRMD server acc found in the tree");
			return false;
		}
*/
	}
	else
	{
		return false;
	}

	String valueOriginationid;
	if (e_Ok != m_pProfile->GetMOTreeManager()->GetValue(URI_DIAGNOSTICS_ORIGINATIONID, valueOriginationid, NULL))
	{
		return false;
	}

	ICommand* cmd = new NotifySEMDRMDReadyCommand(m_pProfile, valueServerid, valueOriginationid);
	if (cmd)
	{
		if (!m_pProfile->GetExecutionQueue()->Add(*cmd))
		{
			delete cmd;
			cmd = NULL;
		}
	}
	
	return cmd != NULL;
}


