/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include <syncml/core/DevInf.h>
#include "serverexchange/IServerExchangeManager.h"
#include "daemon/ProfileComponentsHolder.h"
#include "serverexchange/commands/DevDetailCommand.h"
#include "treemanager/IMOTreeManager.h"
#include "treemanager/TreeLocations.h"

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_Communication;


DevDetailCommand::DevDetailCommand(ProfileComponentsHolder * pHolder) :
	m_pProfileHolder(pHolder)
{
}


DevDetailCommand::~DevDetailCommand()
{
}


bool DevDetailCommand::Execute()
{
	String result;

	Funambol::DevInf di;
	Funambol::VerDTD v("1.2");
    di.setVerDTD(&v);

	// perform all Get operations in root mode
	if (e_Ok == m_pProfileHolder->GetMOTreeManager()->GetValue(DI_DEVID, result, NULL))
		di.setDevID(result.c_str());
	else
		di.setDevID("");
	
	if (e_Ok == m_pProfileHolder->GetMOTreeManager()->GetValue(DI_MAN, result, NULL))
		di.setMan(result.c_str());
	else
		di.setMan("");

	if (e_Ok == m_pProfileHolder->GetMOTreeManager()->GetValue(DI_MOD, result, NULL))
		di.setMod(result.c_str());
	else
		di.setMod("");

	if (e_Ok == m_pProfileHolder->GetMOTreeManager()->GetValue(DD_OEM, result, NULL))
		di.setOEM(result.c_str());
	else
		di.setOEM("");
	
	if (e_Ok == m_pProfileHolder->GetMOTreeManager()->GetValue(DI_DMV, result, NULL))
		di.setDmV(result.c_str());
	else
		di.setDmV("");

	if (e_Ok == m_pProfileHolder->GetMOTreeManager()->GetValue(DI_LANG, result, NULL))
		di.setLang(result.c_str());
	else
		di.setLang("");

	
	if (e_Ok == m_pProfileHolder->GetMOTreeManager()->GetValue(DD_FWV, result, NULL))
		di.setFwV(result.c_str());
	else
		di.setFwV("");

	if (e_Ok == m_pProfileHolder->GetMOTreeManager()->GetValue(DD_SWV, result, NULL))
		di.setSwV(result.c_str());
	else
		di.setSwV("");

	if (e_Ok == m_pProfileHolder->GetMOTreeManager()->GetValue(DD_HWV, result, NULL))
		di.setHwV(result.c_str());
	else
		di.setHwV("");


	if (e_Ok == m_pProfileHolder->GetMOTreeManager()->GetValue(DD_DEVTYP, result, NULL))
		di.setDevTyp(result.c_str());
	else
		di.setDevTyp("");

	if (e_Ok == m_pProfileHolder->GetMOTreeManager()->GetValue(DD_LOBJ, result, NULL))
	{
		if (!result.compare("true"))
			di.setSupportLargeObjs(true);
		else if (!result.compare("false"))
			di.setSupportLargeObjs(false);
		else
			di.setSupportLargeObjs(false);
	}
	else
		di.setSupportLargeObjs(false);

	di.setUTC(false);
	di.setSupportNumberOfChanges(false);

	m_pProfileHolder->GetServerExchangeManager()->SetDevInfo(di);

    return true;
}
