/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include <base/util/utils.h>
#include <Utils.h>
#include <syncml/formatter/Formatter.h>
#include <syncml/core/ComplexData.h>
#include <syncml/core/SourceRef.h>
#include <syncml/core/TargetRef.h>
#include "serverexchange/wrappers/SStatusCommand.h"
#include "commontypes.h"
#include <Logger/LoggerMacroses.h>


using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_SyncMLCommand;


SStatusCommand::SStatusCommand() :
	m_data(0), m_cmdName(NULL), m_targetref(NULL), m_sourceref(NULL)
{
}


SStatusCommand::SStatusCommand(int data) :
	m_data(data), m_cmdName(NULL), m_targetref(NULL), m_sourceref(NULL)
{
}


SStatusCommand::SStatusCommand(int data, AbstractCommandPtr origcmd) :
	m_data(data), m_cmdName(NULL), m_targetref(NULL), m_sourceref(NULL)
{
	if (origcmd.get())
	{
		SetCmd(origcmd->getName());
		if (origcmd->getCmdID())
			SetCmdRef(origcmd->getCmdID()->getCmdID());
	}
}


SStatusCommand::~SStatusCommand()
{
	SAFE_DELETE_ARR(m_cmdName);
	SAFE_DELETE_ARR(m_targetref);
	SAFE_DELETE_ARR(m_sourceref);
}


void SStatusCommand::createItemizedCommand()
{
	Funambol::Status * pStatus = new Funambol::Status();
	m_ptrItemizedCommand.reset(pStatus);

	Funambol::Data data(m_data);
	pStatus->setData(&data);
	pStatus->setCmd(m_cmdName);
	pStatus->setCmdRef(GetCmdRef());
	pStatus->setMsgRef(GetMsgRef());

	if (m_sourceref)
	{
		Funambol::ArrayList sources;
		Funambol::SourceRef source(m_sourceref);
		sources.add(source);
		this_status()->setSourceRef(&sources);
	}

	if (m_targetref)
	{
		Funambol::ArrayList targets;
		Funambol::TargetRef target(m_targetref);
		targets.add(target);
		this_status()->setTargetRef(&targets);
	}
}


Funambol::Status * SStatusCommand::GetStatus()
{
	return this_status();
}


int  SStatusCommand::GetData()
{
	return m_data;
}


void SStatusCommand::SetData(int data)
{
	m_data = data;
	if (m_ptrItemizedCommand.get())
	{
		char bf[DIM_64];
		__sprintf(bf, "%d", m_data);
		Funambol::ComplexData data(bf);
		this_status()->setData(&data);
	}
}


void SStatusCommand::SetCmd(const char *cmdName)
{
	SAFE_DELETE_ARR(m_cmdName);
	m_cmdName = Funambol::stringdup(cmdName);
}


void SStatusCommand::SetTargetRef(const char *target)
{
	SAFE_DELETE_ARR(m_targetref);
	m_targetref = Funambol::stringdup(target);
}


void SStatusCommand::SetSourceRef(const char *source)
{
	SAFE_DELETE_ARR(m_sourceref);
	m_sourceref = Funambol::stringdup(source);
}


Funambol::StringBuffer * SStatusCommand::ToString()
{
	if (m_ptrItemizedCommand.get())
		return Funambol::Formatter::getStatus(this_status());
	else
		return SCommandAdapter::ToString();
}

