/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "treemanager/MOTreeManagerListenerCollection.h"
#include "treemanager/IMOTreeManagerListener.h"

#include "daemon/ProfileComponentsHolder.h"

#include "treemanager/ServerPollingListener.h"
#include "treemanager/FUMORefUpdateListener.h"

static const char* const c_FUMODefURIParam = "FUMODefURI";
static const char* const c_DefaultFUMODefURI = "./FUMO";

namespace NS_DM_Client
{
//-------------------------------------------------------------------------------------------
bool MOTreeManagerListenerCollection::Init(ProfileComponentsHolder& pch, const StringMap& settings)
{
    bool res = true;

    m_settings = settings;

    return res;
}
//-------------------------------------------------------------------------------------------
bool MOTreeManagerListenerCollection::AddListener(IMOTreeManagerListener* listener)
{
    bool res = true;
    m_listeners.push_back(listener);
    return res;
}
//-------------------------------------------------------------------------------------------
bool MOTreeManagerListenerCollection::Release()
{
    bool res = true;

    for (std::vector<IMOTreeManagerListener*>::size_type i = 0; i < m_listeners.size(); ++i)
    {
        (m_listeners[i])->Release();
    }

    delete this;
    return res;
}

//-------------------------------------------------------------------------------------------

bool MOTreeManagerListenerCollection::ExecuteOnAdd(const URI& uri)
{
    for (std::vector<IMOTreeManagerListener*>::size_type i = 0; i < m_listeners.size(); ++i)
    {
        m_listeners[i]->ExecuteOnAdd(uri);
    }

    return true;
}

//-------------------------------------------------------------------------------------------

bool MOTreeManagerListenerCollection::ExecuteOnDelete(const URI& uri)
{
    return true;
}

//-------------------------------------------------------------------------------------------

bool MOTreeManagerListenerCollection::ExecuteOnReplace(const URI& uri)
{
    for (std::vector<IMOTreeManagerListener*>::size_type i = 0; i < m_listeners.size(); ++i)
    {
        m_listeners[i]->ExecuteOnReplace(uri);
    }

    return true;
}

//-------------------------------------------------------------------------------------------

bool MOTreeManagerListenerCollection::ExecuteOnReplaceProperty(const URI& uri, const String& property_name)
{
    return true;
}

//-------------------------------------------------------------------------------------------

bool MOTreeManagerListenerCollection::ExecuteOnCopy(const URI& source, const URI& dest)
{
    return true;
}

//-------------------------------------------------------------------------------------------

MOTreeManagerListenerCollection* GetMOTreeManagerListenerCollection(ProfileComponentsHolder& pch,const StringMap& settings)
{
    MOTreeManagerListenerCollection* ret = new MOTreeManagerListenerCollection;
    if (ret)
    {
        if (ret->Init(pch, settings))
        {
            // create predefined listeners

	        while (true)
	        {
	            // Server Polling listener
	            TreeServerPollingListener* server_polling_listener = new TreeServerPollingListener(pch);
                if (server_polling_listener)
                {
                    if (server_polling_listener->Init(pch))
                    {
                        ret->AddListener(server_polling_listener);
                    }
                    else
                    {
                        ret->Release();
                        ret = 0;
                        break;
                    }
                }
                else
                {
                    ret->Release();
                    ret = 0;
                    break;
                }

                // TO-FUMO-REF listener
	            FUMORefUpdateListener* fumo_ref_listener = new FUMORefUpdateListener(pch);
                if (fumo_ref_listener)
                {
                    if (fumo_ref_listener->Init(pch))
                    {
                        const char* defValue = (const_cast<StringMap&>(settings).get(c_FUMODefURIParam)).c_str();
                        fumo_ref_listener->SetDefaultValue(defValue ? defValue : c_DefaultFUMODefURI);
                        ret->AddListener(fumo_ref_listener);
                    }
                    else
                    {
                        ret->Release();
                        ret = 0;
                        break;
                    }
                }
                else
                {
                    ret->Release();
                    ret = 0;
                    break;
                }

	            break;
	        }
	    }
    }
    return ret;
}

}
