/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#pragma once

#include <vector>
#include <commontypes.h>

namespace Funambol
{
    class Item;
}

namespace NS_Logging
{
	class Logger;
}

namespace NS_DM_Client
{
	namespace NS_DataStorage
	{
		class IDataStorage;
	}
}

namespace NS_DM_Client
{

enum TransactionElementType
{
    e_transactionAdd,
    e_transactionDelete,
    e_transactionReplace,
    e_transactionReplaceProperty,
    e_transactionCopy
};

struct TransactionMOProperty
{
    String m_name;
    String m_value;
};

struct TransactionMONode
{
    String m_name;
    String m_value;
    std::vector<TransactionMOProperty> m_properties;
};

struct TransactionDataElement
{
    TransactionElementType m_type;
    TransactionMONode m_before;
    TransactionMONode m_after;
    bool m_needSerialize;
};

class MOTreeManagerTransaction;
class Node;

class MOTreeManagerTransactionData
{
    friend class MOTreeManagerTransaction;

public:
	MOTreeManagerTransactionData();
    ~MOTreeManagerTransactionData();

    bool BackupAdd(const URI& uri, bool needSerialize = true);
    bool BackupDelete(const URI& uri);
    bool BackupReplace(const URI& uri, const String& rep_value, bool needSerialize = true);
    bool BackupReplaceProperty(const URI& uri, const String& property_name, const String& rep_value);
    bool BackupCopy(const URI& source, const URI& dest);

private:
    TransactionDataElement* getFirstTransactionElement();
    TransactionDataElement* getNextTransactionElement();

    bool backupDeleteSubnodes(Node& parent);

    bool backupNode(Node& node, const String& operation, void* additional_data = 0, bool needSerialize = true);

    bool rollbackAdd(const TransactionDataElement* data);
    bool rollbackDelete(const TransactionDataElement* data);
    bool rollbackReplace(const TransactionDataElement* data);
    bool rollbackReplaceProperty(const TransactionDataElement* data);
    bool rollbackCopy(const TransactionDataElement* data);

    void clearData();

    void setDataElementBackupType(const String& operation, TransactionDataElement& data);

private:
	NS_DataStorage::IDataStorage* m_dataStorage;
    std::vector<TransactionDataElement> m_data;
    std::vector<TransactionDataElement>::size_type m_cucle_index;
};


}
