/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include <syncml/core/Get.h>
#include <syncml/core/Item.h>
#include <syncml/core/Source.h>

#include "commontypes.h"
#include "daemon/ProfileComponentsHolder.h"
#include "Logger/LoggerMacroses.h"

#include "treemanager/IMOTreeManager.h"
#include "treemanager/MOTreeGetResponseCommand.h"
#include "serverexchange/IServerExchangeManager.h"
#include "serverexchange/ICommandsSink.h"
#include "serverexchange/wrappers/SCommandFactory.h"

#define LOG_INFO_ NS_Logging::FunctionNameLogHelper(__FUNCTION__, NS_Logging::e_info).Log
#define LOG_ NS_Logging::FunctionNameLogHelper(__FUNCTION__, NS_Logging::e_info).Log

using namespace NS_DM_Client;

const char* const c_LogName = "MOTreeGetResponseCommand";

MOTreeGetResponseCommand::MOTreeGetResponseCommand
    (ProfileComponentsHolder* prholder, GetPtr& cmd, StatusCode getCommandStatus, const String& msgID, const char *serverid)
    : MOTreeResponseCommand(prholder, cmd, getCommandStatus, msgID, serverid), m_GetCommand(cmd)
{
}


MOTreeGetResponseCommand::~MOTreeGetResponseCommand()
{
}


bool MOTreeGetResponseCommand::Execute()
{
    GDLINFO("%s", "FUNCTION STARTED");

    bool res = m_pProfile && m_GetCommand.get();
    if (res)
    {
		res = performOperation();
    }
    else
    {
        GDLERROR("%s", "component holder or command instanse not valid");
    }
    GDLINFO("%s%d", "FUNCTION END. Res: ", res);
    return res;
}


bool MOTreeGetResponseCommand::performOperation()
{
    bool res = false;
    // create status message
    SStatusCommandPtr ptrStatus =
        NS_SyncMLCommand::SCommandFactory::CreateStatus(m_status, *m_GetCommand.get());

    if (ptrStatus.get())
    {
        // create response message only if Status code = Ok
        if (m_status == e_Ok)
        {
			GDLINFO("StatusCode is Ok. Items count: %d. Starting result creation",
				m_GetCommand.get()->getItems()->size());
            SResultsCommandPtr ptrResults =
                NS_SyncMLCommand::SCommandFactory::CreateResult(*(m_GetCommand.get()),
																*(m_GetCommand.get()->getItems()),
																 m_messageID.c_str());
            if (ptrResults.get() != 0)
            {
				SCommandsArray results;
				results.push_back(ptrStatus);
				results.push_back(ptrResults);
				if (/*m_pSEM &&*/ m_serverID && m_pCommandsSink)
					m_pCommandsSink->AddCommands(results, m_serverID);
					//m_pProfile->GetServerExchangeManager()->AddCommands(results, m_serverID);
				else
					GDLERROR("no SEM instance is set");
            }
            else
            {
            	GDLERROR("%s", "SCommandFactory::CreateResultMessage failed");
            }
            res = true;
        }
        else
        {
            enqueueCommand(ptrStatus);
        }
    }
    else
    {
        GDLERROR("%s", "SCommandFactory::CreateStatusMessage failed");
    }

    return res;
}
