/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "treemanager/MOTreeReplaceCommand.h"
#include "treemanager/IMOTreeManager.h"

#include "syncml/core/Replace.h"
#include "syncml/core/Item.h"
#include "syncml/core/Source.h"

#include "commontypes.h"
#include "Errors.h"

#include "executionqueue/IExecutionQueue.h"
#include "Logger/Logger.h"
#include "Logger/LoggerMacroses.h"

const char* const c_LogName = "MOTreeReplaceCommand";

const char* const c_ReplaceCommandLog = "MOTreeReplaceCommand";

const char* const c_PropertyDelimiter = "?prop=";

#define LOG_INFO_ NS_Logging::FunctionNameLogHelper(__FUNCTION__, NS_Logging::e_info).Log

using namespace NS_DM_Client;


MOTreeReplaceCommand::MOTreeReplaceCommand(ProfileComponentsHolder* prholder,
										   ReplacePtr& cmd,
										   const String& msgID,
								            const char* serverId)
    : ActionCommand(prholder, cmd, msgID, serverId), m_ReplaceCommand(cmd)
{
}


MOTreeReplaceCommand::~MOTreeReplaceCommand(void)
{
}


bool MOTreeReplaceCommand::Execute()
{
    LOG_INFO_(NS_Logging::GetLogger(c_ReplaceCommandLog), "%s", "FUNCTION STARTED");

    bool res = m_pProfile && m_ReplaceCommand.get();
    if (res)
    {
		res = false;
		m_resCode = performOperation();
		res = InvokeResult();
    }
    else
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_ReplaceCommandLog),
            "%s", "component holder or command instanse not valid");
    }

    LOG_INFO_(NS_Logging::GetLogger(c_ReplaceCommandLog), "%s%d", "FUNCTION END. Res: ", res);
    return res;
}


StatusCode MOTreeReplaceCommand::performOperation()
{
    StatusCode res = e_Ok;
    Funambol::ArrayList* items = m_ReplaceCommand->getItems();
    if (items)
    {
        Funambol::Item* item = 0;
        int count = items->size();
        for (int i = 0; i < count; ++i)
        {
            if ((item = dynamic_cast<Funambol::Item*> ((*items)[i])) != 0)
            {
				if (!item->getTarget())
				{
					GDLERROR("Item in Replace command has no Target node");
					res = e_CommandFailed;
					break;
				}

                const URI uri = item->getTarget()->getLocURI();
                URI res_uri = uri;
                // check if uri represent property
                size_t pos = uri.find(c_PropertyDelimiter);
                URI property_name;
                String property_value;
                if (pos != URI::npos)
                {   // we have property request
                    property_value = item->getData()->getData();
                    res_uri = uri.substr(0, pos);
                    property_name = uri.substr(pos + strlen(c_PropertyDelimiter));
                    if ((res = m_pProfile->GetMOTreeManager()->ReplacePropertyValue(res_uri, property_name, property_value, m_serverID)) != e_Ok)
                    {
                        LOG_ERROR_(NS_Logging::GetLogger(c_ReplaceCommandLog),
                            "%s", "replace item property from MO Tree Manager failed");
                        break;
                    }
                }
                else
                {
                    if ( (res = m_pProfile->GetMOTreeManager()->Replace(uri, *item, m_serverID)) != e_Ok)
                    {
                        LOG_ERROR_(NS_Logging::GetLogger(c_ReplaceCommandLog),
                            "%s", "replace item on MO Tree Manager failed");
                        break;
                    }
                }
            }
            else
            {
                LOG_ERROR_(NS_Logging::GetLogger(c_ReplaceCommandLog),
                    "%s", "casting to Funambol::Item failed");
                break;
            }
        }
    }
    else
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_ReplaceCommandLog),
            "%s", "get items from ItemizedCommand failed");
    }
    return res;
}

