/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "treemanager/ServerPollingListener.h"
#include "commontypes.h"
#include "treemanager/IMOTreeManager.h"

#include "SetServerPollerInfoCommand.h"
#include "executionqueue/ExecutionQueue.h"

const size_t listen_uris_count = 3;
const char* listen_uris[listen_uris_count] =
{
    "./WiMAX/DevCap/UpdateMethods/ClientInitiated/PollingAttempts",
    "./WiMAX/DevCap/UpdateMethods/ClientInitiated/PollingInterval",
    "./WiMAX/DevCap/UpdateMethods/ClientInitiated/PollingSupported"
};

namespace NS_DM_Client
{
	TreeServerPollingListener::TreeServerPollingListener(ProfileComponentsHolder& pch): m_component_holder(pch)
	{

	}

//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::Init(ProfileComponentsHolder& pch)
{
    return true;
}
//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::Release()
{
	delete this;
    return true;
}
//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::ExecuteOnAdd(const URI& uri)
{
    if (isListenURI(uri))
    {
        notifyExchangeServer(uri);
    }
    return true;
}
//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::ExecuteOnDelete(const URI& uri)
{
    return true;
}
//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::ExecuteOnReplace(const URI& uri)
{
    if (isListenURI(uri))
    {
        notifyExchangeServer(uri);
    }
    return true;
}
//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::ExecuteOnReplaceProperty(const URI& uri, const String& property_name)
{
    return true;
}
//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::ExecuteOnCopy(const URI& source, const URI& dest)
{
    return true;
}
//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::isListenURI(const URI& uri)
{
    for (size_t i = 0; i < listen_uris_count; ++i)
    {
        if (uri.compare(listen_uris[i]) == 0)
        {
            return true;
        }
    }
    return false;
}
//-------------------------------------------------------------------------------------------
bool TreeServerPollingListener::notifyExchangeServer(const URI& uri)
{
    bool pollingSupported = false;
    int pollingInterval = 0;
    int pollingAttempts = 0;
    String value;

    if ((!m_component_holder.GetMOTreeManager()) || (!m_component_holder.GetExecutionQueue()))
    {
        return false;
    }

    if (m_component_holder.GetMOTreeManager()->GetValue(listen_uris[0], value)) // PollingAttempts
    {
        sscanf(value.c_str(), "%d", &pollingAttempts);
    }
    else
    {
        return false;
    }
    if (m_component_holder.GetMOTreeManager()->GetValue(listen_uris[1], value)) // PollingInterval
    {
        sscanf(value.c_str(), "%d", &pollingInterval);
    }
    else
    {
        return false;
    }
    if (m_component_holder.GetMOTreeManager()->GetValue(listen_uris[2], value)) // PollingSupported
    {
        if (value.compare("true"))
        {
            pollingSupported = true;
        }
    }
    else
    {
        return false;
    }

    SetServerPollerInfoCommand* pollerCommand = new SetServerPollerInfoCommand(m_component_holder, pollingSupported, pollingInterval, pollingAttempts);
    IExecutionQueue* queue = m_component_holder.GetExecutionQueue();
    if (queue)
    {
        queue->Add(*pollerCommand);
    }
    return true;
}
//-------------------------------------------------------------------------------------------
}
