/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "commontypes.h"
#include "platform.h"

#ifdef PLATFORM_LINUX
#define CLIENTADAPTER_API
#elif defined(PLATFORM_WINDOWS)
#ifdef CLIENTADAPTER_EXPORTS
#define CLIENTADAPTER_API __declspec(dllexport)
#else
#define CLIENTADAPTER_API __declspec(dllimport)
#endif // CLIENTADAPTER_EXPORTS
#else
#define CLIENTADAPTER_API
#endif

#include "daemon/INotification.h"
#include "ProvisionInfo.h"
#include "IRequestHandler.h"
#include "INotificationUpdater.h"

namespace NS_DM_Client
{
	class DevInfo;
	class DevDetail;
	class DMAcc;
	class WiMAX;
	class WiMAXSupp;
	class INotificationUpdater;
	namespace NS_DM_Diagnostics
	{
		class WiMAX_Diagnostics;
	}

	struct ProvisionInfoRequest;

	class ClientProfileInfo
	{
	public:
		String m_name;
		String m_type;
		String m_description;
	};

	enum MOType
	{
		e_NotWellKnownMO,

		e_MODevInfo,
		e_MODevDetail,
		e_MODMAcc,

	};

	class IConfirmation: public INotificationUpdater
	{
	public:
		virtual void ConfirmationRequired(const String& message) = 0;
	};

	class IStatusCallback: public INotificationUpdater
	{
	public:
		virtual void StatusResponse(bool status) = 0;
	};
	

	class IClientAdapter
	{
	public:
		virtual ~IClientAdapter() {};
		virtual bool Open() = 0; // open connection to DMClient
		virtual bool Close() = 0; // close connection to DMClient
		virtual void Release() = 0;

		virtual bool ChangeDefaultAccountPassword(const String &oldpass, const String &newpass) = 0;
		virtual bool ChangeAccountPassword(const String& serverID, const String &oldpass, const String &newpass) = 0;
		typedef std::vector<ClientProfileInfo>	ClientProfiles;
		virtual bool GetClientProfiles(ClientProfiles& profiles) = 0;
		virtual bool SwitchClientProfile(const String& profileName) = 0;
		virtual bool GetProfileActivationStatus(bool& isActive) = 0; // check if current profile is active
		virtual bool GetProfileActivationStatus(const String& serverID, bool& isActive) = 0; // check if profile with specific ServerID is active


		virtual bool HandleNetworkEntry(int homeNspID, const char* operatorName) = 0;

		virtual bool GetDeviceInfo(DevInfo& deviceInfo) = 0;
		virtual bool GetDeviceDetail(DevDetail& deviceDetail) = 0;
		virtual bool GetDMAccount(DMAcc& dmAccount) = 0;
		virtual bool GetWiMAX(WiMAX& wimax) = 0;
		virtual bool GetWiMAXSupp(WiMAXSupp& wimaxSupp) = 0;

		virtual bool SetDeviceInfo(const DevInfo& deviceInfo) = 0;
		virtual bool SetDeviceDetail(const DevDetail& deviceDetail) = 0;
		virtual bool SetDMAccount(const DMAcc& dmAccount) = 0;
		virtual bool SetWiMAX(const WiMAX& wimax) = 0;
		virtual bool SetWiMAXSupp(const WiMAXSupp& wimaxSupp) = 0;
		virtual bool SetWiMAXDiagnostics(const NS_DM_Diagnostics::WiMAX_Diagnostics& wimaxDiagnostics) = 0;
		
		virtual bool DRMDReady() = 0;

		virtual bool StartDMSession(const String& alertMessage, IStatusCallback* statusCallback) = 0;
		virtual bool StartBootstrapRequest() = 0;
		virtual bool StartDRMD() = 0;
		virtual bool CheckForFirmwareUpdate(IStatusCallback* statusCallback) = 0;

		virtual bool SubscribeToDMSessionNotification(INotificationUpdater* updater) = 0;
		virtual bool SubscribeToFirmwareNotification(INotificationUpdater* updater) = 0;
		virtual bool SubscribeToDRMDNotif(INotificationUpdater* updater) = 0;
		virtual bool SubscribeToNotification(const ProvisionInfoRequest& provInfo, INotificationUpdater* updater) = 0;

		// subscribe to receive confirmation request. After receiving request call SendConfirmationResponse
		virtual bool SubscribeToConfirmation(IConfirmation* confirmation) = 0;
		virtual bool SendConfirmationResponse(const String& request, ResponseCode confCode) = 0;

		virtual bool UnsubscribeToDMSessionNotif() = 0;
		virtual bool UnsubscribeToFirmwareUpdateNotif() = 0;
		virtual bool UnsubscribeToProvisioningUpdateNotif() = 0;

		virtual bool SetMgmtTree(const String& mgmtTree) = 0;
		virtual bool GetMgmtTree(const String& uri, String& mgmtTree) = 0;

		virtual bool SetEMSK(const void* buffer, size_t count) = 0;
		virtual bool SetDeviceID(const void* buffer, size_t count) = 0;
		virtual bool SetManufacturer(const void* buffer, size_t count) = 0;
		virtual bool SetModel(const void* buffer, size_t count) = 0;

		//virtual bool UnSubscribeFromNotification();
	};
}
extern "C" CLIENTADAPTER_API void* CreateClientAdapter();

